/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.Container;
import org.xwiki.observation.remote.NetworkAdapter;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.RemoteEventException;
import org.xwiki.observation.remote.jgroups.JGroupsReceiver;

@Component
@Named(value="jgroups")
@Singleton
public class JGroupsNetworkAdapter
extends AbstractLogEnabled
implements NetworkAdapter {
    public static final String CONFIGURATION_PATH = "observation/remote/jgroups/";
    @Inject
    private Container container;
    @Inject
    private ComponentManager componentManager;
    private Map<String, JChannel> channels = new ConcurrentHashMap<String, JChannel>();

    public void send(RemoteEventData remoteEvent) {
        this.getLogger().debug("Send JGroups remote event [" + remoteEvent + "]");
        Message message = new Message(null, null, (Serializable)remoteEvent);
        for (Map.Entry<String, JChannel> entry : this.channels.entrySet()) {
            try {
                entry.getValue().send(message);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to send message [" + remoteEvent + "] to the channel [" + entry.getKey() + "]", (Throwable)e);
            }
        }
    }

    public void startChannel(String channelId) throws RemoteEventException {
        JChannel channel;
        if (this.channels.containsKey(channelId)) {
            throw new RemoteEventException(MessageFormat.format("Channel [{0}] already started", channelId));
        }
        try {
            channel = this.createChannel(channelId);
            channel.connect("event");
            this.channels.put(channelId, channel);
        }
        catch (Exception e) {
            throw new RemoteEventException("Failed to create channel [" + channelId + "]", e);
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)mbs, (String)channel.getClusterName());
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to register channel [" + channelId + "] against the JMX Server", (Throwable)e);
        }
        this.getLogger().info(MessageFormat.format("Channel [{0}] started", channelId));
    }

    public void stopChannel(String channelId) throws RemoteEventException {
        JChannel channel = this.channels.get(channelId);
        if (channel == null) {
            throw new RemoteEventException(MessageFormat.format("Channel [{0}] is not started", channelId));
        }
        channel.close();
        this.channels.remove(channelId);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            JmxConfigurator.unregister((Object)channel, (MBeanServer)mbs, (String)channel.getClusterName());
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to unregister channel [" + channelId + "] from the JMX Server", (Throwable)e);
        }
        this.getLogger().info(MessageFormat.format("Channel [{0}] stopped", channelId));
    }

    private JChannel createChannel(String channelId) throws ComponentLookupException, ChannelException {
        JGroupsReceiver channelReceiver;
        ProtocolStackConfigurator channelConf;
        try {
            channelConf = this.loadChannelConfiguration(channelId);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to load configuration for the channel [" + channelId + "]", (Throwable)e);
        }
        try {
            channelReceiver = (JGroupsReceiver)this.componentManager.lookup(JGroupsReceiver.class, channelId);
        }
        catch (ComponentLookupException e) {
            channelReceiver = (JGroupsReceiver)this.componentManager.lookup(JGroupsReceiver.class);
        }
        JChannel channel = new JChannel(channelConf);
        channel.setReceiver((Receiver)channelReceiver);
        channel.setOpt(3, (Object)false);
        return channel;
    }

    private ProtocolStackConfigurator loadChannelConfiguration(String channelId) throws IOException, ChannelException {
        XmlConfigurator configurator;
        String path = "/WEB-INF/observation/remote/jgroups/" + channelId + ".xml";
        InputStream is = this.container.getApplicationContext().getResourceAsStream(path);
        if (is != null) {
            configurator = XmlConfigurator.getInstance((InputStream)is);
        } else {
            this.getLogger().warn("Can't find a configuration for channel [" + channelId + "] at [" + path + "]. Using " + "udp.xml" + " JGroups default configuration.");
            configurator = ConfiguratorFactory.getStackConfigurator((String)"udp.xml");
        }
        return configurator;
    }

    public void stopAllChannels() throws RemoteEventException {
        for (Map.Entry<String, JChannel> channelEntry : this.channels.entrySet()) {
            channelEntry.getValue().close();
        }
        this.channels.clear();
        this.getLogger().info("All channels stopped");
    }
}

