/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.jgroups;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.RemoteObservationManager;
import org.xwiki.observation.remote.jgroups.JGroupsReceiver;

@Component
@Singleton
public class DefaultJGroupsReceiver
implements JGroupsReceiver {
    private RemoteObservationManager remoteObservationManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public RemoteObservationManager getRemoteObservationManager() {
        if (this.remoteObservationManager == null) {
            try {
                this.remoteObservationManager = (RemoteObservationManager)this.componentManager.lookup(RemoteObservationManager.class);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup the Remote Observation Manager.", (Throwable)e);
            }
        }
        return this.remoteObservationManager;
    }

    public byte[] getState() {
        return null;
    }

    public void receive(Message msg) {
        RemoteEventData remoteEvent = (RemoteEventData)msg.getObject();
        this.logger.debug("Received JGroups remote event [" + remoteEvent + "]");
        this.getRemoteObservationManager().notify(remoteEvent);
    }

    public void setState(byte[] state) {
    }

    public void block() {
    }

    public void suspect(Address suspectedMbr) {
    }

    public void viewAccepted(View newView) {
    }
}

