/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteObservationManager;
import org.xwiki.observation.remote.RemoteObservationManagerConfiguration;

@Component
@Named(value="observation.remote")
@Singleton
public class LocalEventListener
implements EventListener {
    private static final String NAME = "observation.remote";
    @Inject
    private RemoteObservationManagerConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private RemoteObservationManager remoteObservationManager;

    public List<Event> getEvents() {
        List<Object> events = this.configuration.isEnabled() ? Collections.singletonList(AllEvent.ALLEVENT) : Collections.emptyList();
        return events;
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.remoteObservationManager == null) {
            try {
                ((ObservationManager)this.componentManager.lookup(ObservationManager.class)).removeListener(this.getName());
                this.remoteObservationManager = (RemoteObservationManager)this.componentManager.lookup(RemoteObservationManager.class);
                ((ObservationManager)this.componentManager.lookup(ObservationManager.class)).addListener((EventListener)this);
                this.remoteObservationManager.notify(new LocalEventData(event, source, data));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to initialize the Remote Observation Manager", (Throwable)e);
            }
        } else {
            this.remoteObservationManager.notify(new LocalEventData(event, source, data));
        }
    }
}

