/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.office;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.office.viewer.OfficeViewer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.office.OfficeMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="office")
@Singleton
public class OfficeMacro
extends AbstractMacro<OfficeMacroParameters> {
    @Inject
    private OfficeViewer officeViewer;
    @Inject
    @Named(value="macro")
    private AttachmentReferenceResolver<String> macroAttachmentReferenceResolver;

    public OfficeMacro() {
        super("Office Document Viewer", "View office attachments (doc, ppt, xls, odt, odp, ods etc.) inside wiki pages without downloading or importing them.", OfficeMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(OfficeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        AttachmentReference attachmentReference = this.resolve(context.getCurrentMacroBlock(), parameters);
        Map<String, String> viewParameters = Collections.singletonMap("filterStyles", String.valueOf(parameters.isFilterStyles()));
        try {
            return this.officeViewer.createView(attachmentReference, viewParameters).getChildren();
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to view office attachment.", (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }

    private AttachmentReference resolve(MacroBlock block, OfficeMacroParameters parameters) throws MacroExecutionException {
        String reference = parameters.getAttachment();
        if (StringUtils.isEmpty((CharSequence)reference)) {
            throw new MacroExecutionException("You must specify the 'attachment' parameter pointing to the office file to display.");
        }
        return this.macroAttachmentReferenceResolver.resolve((Object)reference, new Object[]{block});
    }
}

