/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.office.viewer.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.container.Container;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.office.viewer.OfficeViewer;
import org.xwiki.office.viewer.internal.OfficeDocumentView;
import org.xwiki.rendering.block.XDOM;

public abstract class AbstractOfficeViewer
implements OfficeViewer,
Initializable {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MODULE_NAME = "officeviewer";
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    private Container container;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private Logger logger;
    private Cache<OfficeDocumentView> cache;

    public void initialize() throws InitializationException {
        CacheConfiguration config = new CacheConfiguration();
        config.setConfigurationId(MODULE_NAME);
        try {
            this.cache = this.cacheManager.createNewCache(config);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to create cache.", (Throwable)e);
        }
    }

    @Override
    public XDOM createView(AttachmentReference attachmentReference, Map<String, String> parameters) throws Exception {
        String cacheKey = this.getCacheKey(attachmentReference, parameters);
        OfficeDocumentView view = (OfficeDocumentView)this.cache.get(cacheKey);
        DocumentReference documentReference = attachmentReference.getDocumentReference();
        if (!this.documentAccessBridge.getAttachmentReferences(documentReference).contains(attachmentReference)) {
            if (view != null) {
                this.cache.remove(cacheKey);
            }
            throw new Exception(String.format("Attachment [%s] does not exist.", attachmentReference));
        }
        String currentVersion = this.documentAccessBridge.getAttachmentVersion(attachmentReference);
        if (view != null && !currentVersion.equals(view.getVersion())) {
            this.cache.remove(cacheKey);
            view = null;
        }
        if (view == null) {
            view = this.createOfficeDocumentView(attachmentReference, parameters);
            this.cache.set(cacheKey, (Object)view);
        }
        return view.getXDOM().clone();
    }

    private String getCacheKey(AttachmentReference attachmentReference, Map<String, String> viewParameters) {
        return (String)this.serializer.serialize((EntityReference)attachmentReference, new Object[0]) + '/' + ((Object)viewParameters).hashCode();
    }

    protected abstract OfficeDocumentView createOfficeDocumentView(AttachmentReference var1, Map<String, String> var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File saveTemporaryFile(AttachmentReference attachmentReference, String fileName, byte[] fileData) throws Exception {
        File file;
        File tempFile = new File(this.getTemporaryDirectory(attachmentReference), fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            IOUtils.write((byte[])fileData, (OutputStream)fos);
            tempFile.deleteOnExit();
            file = tempFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return file;
    }

    protected File getTemporaryDirectory(AttachmentReference attachmentReference) throws Exception {
        boolean success;
        String wiki = attachmentReference.getDocumentReference().getWikiReference().getName();
        String space = attachmentReference.getDocumentReference().getParent().getName();
        String page = attachmentReference.getDocumentReference().getName();
        String attachmentName = attachmentReference.getName();
        wiki = URLEncoder.encode(wiki, DEFAULT_ENCODING);
        space = URLEncoder.encode(space, DEFAULT_ENCODING);
        page = URLEncoder.encode(page, DEFAULT_ENCODING);
        attachmentName = URLEncoder.encode(attachmentName, DEFAULT_ENCODING);
        String path = String.format("temp/%s/%s/%s/%s/%s/", MODULE_NAME, wiki, space, page, attachmentName);
        File rootDir = this.container.getApplicationContext().getTemporaryDirectory();
        File tempDir = new File(rootDir, path);
        boolean bl = success = (tempDir.exists() || tempDir.mkdirs()) && tempDir.isDirectory() && tempDir.canWrite();
        if (!success) {
            String message = "Error while creating temporary directory for attachment [%s].";
            throw new Exception(String.format(message, attachmentName));
        }
        return tempDir;
    }

    protected String buildURL(AttachmentReference attachmentReference, String fileName) {
        String prefix = this.documentAccessBridge.getDocumentURL(attachmentReference.getDocumentReference(), "temp", null, null, true);
        try {
            String encodedAttachmentName = URLEncoder.encode(attachmentReference.getName(), DEFAULT_ENCODING);
            String encodedFileName = URLEncoder.encode(fileName, DEFAULT_ENCODING);
            return String.format("%s/%s/%s/%s", prefix, MODULE_NAME, encodedAttachmentName, encodedFileName);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Failed to encode URL using UTF-8", (Throwable)e);
            return null;
        }
    }
}

