/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.office.viewer.internal;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.office.viewer.internal.AbstractOfficeViewer;
import org.xwiki.office.viewer.internal.OfficeDocumentView;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Singleton
public class DefaultOfficeViewer
extends AbstractOfficeViewer {
    @Inject
    private XDOMOfficeDocumentBuilder documentBuilder;
    @Inject
    private PresentationBuilder presentationBuilder;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private Logger logger;

    @Override
    protected OfficeDocumentView createOfficeDocumentView(AttachmentReference attachmentReference, Map<String, String> parameters) throws Exception {
        XDOMOfficeDocument xdomOfficeDocument = this.createXDOM(attachmentReference, parameters);
        String attachmentVersion = this.documentAccessBridge.getAttachmentVersion(attachmentReference);
        XDOM xdom = xdomOfficeDocument.getContentDocument();
        Set<File> temporaryFiles = this.processImages(xdom, xdomOfficeDocument.getArtifacts(), attachmentReference);
        return new OfficeDocumentView(attachmentReference, attachmentVersion, xdom, temporaryFiles);
    }

    private Set<File> processImages(XDOM xdom, Map<String, byte[]> artifacts, AttachmentReference attachmentReference) {
        HashSet<File> temporaryFiles = new HashSet<File>();
        List imgBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(ImageBlock.class), Block.Axes.DESCENDANT);
        for (ImageBlock imgBlock : imgBlocks) {
            String imageReference = imgBlock.getReference().getReference();
            if (!artifacts.containsKey(imageReference)) continue;
            try {
                File tempFile = this.getTemporaryFile(attachmentReference, imageReference);
                this.createTemporaryFile(tempFile, artifacts.get(imageReference));
                ResourceReference urlImageReference = new ResourceReference(this.buildURL(attachmentReference, imageReference), ResourceType.URL);
                urlImageReference.setTyped(false);
                ImageBlock newImgBlock = new ImageBlock(urlImageReference, false, imgBlock.getParameters());
                imgBlock.getParent().replaceChild(Arrays.asList(newImgBlock), (Block)imgBlock);
                temporaryFiles.add(tempFile);
            }
            catch (Exception ex) {
                String message = "Error while processing artifact image [%s].";
                this.logger.error(String.format(message, imageReference), (Throwable)ex);
            }
        }
        return temporaryFiles;
    }

    private XDOMOfficeDocument createXDOM(AttachmentReference attachmentReference, Map<String, String> parameters) throws Exception {
        DocumentReference documentReference = attachmentReference.getDocumentReference();
        InputStream officeFileStream = this.documentAccessBridge.getAttachmentContent(attachmentReference);
        String officeFileName = attachmentReference.getName();
        if (this.isPresentation(officeFileName)) {
            return this.presentationBuilder.build(officeFileStream, officeFileName, documentReference);
        }
        boolean filterStyles = Boolean.valueOf(parameters.get("filterStyles"));
        return this.documentBuilder.build(officeFileStream, officeFileName, documentReference, filterStyles);
    }

    private boolean isPresentation(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        OfficeConverter officeConverter = this.officeServer.getConverter();
        if (officeConverter != null) {
            DocumentFormat format = officeConverter.getFormatRegistry().getFormatByExtension(extension);
            return format != null && format.getInputFamily() == DocumentFamily.PRESENTATION;
        }
        return false;
    }
}

