/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.office.viewer.script;

import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.office.viewer.OfficeViewer;
import org.xwiki.office.viewer.OfficeViewerScriptService;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Named(value="officeviewer")
@Singleton
public class DefaultOfficeViewerScriptService
implements OfficeViewerScriptService {
    private static final String OFFICE_VIEW_EXCEPTION = "officeView.caughtException";
    @Inject
    private OfficeViewer officeViewer;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private TransformationManager transformationManager;
    @Inject
    private Logger logger;

    @Override
    public Exception getCaughtException() {
        return (Exception)this.execution.getContext().getProperty(OFFICE_VIEW_EXCEPTION);
    }

    @Override
    public String view(AttachmentReference attachmentReference) {
        Map<String, String> parameters = Collections.emptyMap();
        return this.view(attachmentReference, parameters);
    }

    @Override
    public String view(AttachmentReference attachmentReference, Map<String, String> parameters) {
        this.execution.getContext().removeProperty(OFFICE_VIEW_EXCEPTION);
        try {
            DocumentReference documentReference = attachmentReference.getDocumentReference();
            if (!this.documentAccessBridge.isDocumentViewable(documentReference)) {
                throw new RuntimeException("Inadequate privileges.");
            }
            Syntax fromSyntax = this.documentAccessBridge.getDocument(documentReference).getSyntax();
            Syntax toSyntax = Syntax.XHTML_1_0;
            return this.render(this.officeViewer.createView(attachmentReference, parameters), fromSyntax, toSyntax);
        }
        catch (Exception e) {
            this.execution.getContext().setProperty(OFFICE_VIEW_EXCEPTION, (Object)e);
            this.logger.error("Failed to view office document: " + attachmentReference, (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isMimeTypeSupported(String mimeType) {
        return this.isConversionSupported(mimeType, "text/html");
    }

    private boolean isConversionSupported(String inputMediaType, String outputMediaType) {
        OfficeConverter converter = this.officeServer.getConverter();
        if (converter != null) {
            DocumentFormat inputFormat = converter.getFormatRegistry().getFormatByMediaType(inputMediaType);
            DocumentFormat outputFormat = converter.getFormatRegistry().getFormatByMediaType(outputMediaType);
            return inputFormat != null && outputFormat != null && outputFormat.getStoreProperties(inputFormat.getInputFamily()) != null;
        }
        return false;
    }

    private String render(XDOM xdom, Syntax fromSyntax, Syntax toSyntax) throws Exception {
        TransformationContext context = new TransformationContext(xdom, fromSyntax);
        this.transformationManager.performTransformations((Block)xdom, context);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, toSyntax.toIdString());
        renderer.render((Block)xdom, (WikiPrinter)printer);
        return printer.toString();
    }
}

