/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.panels.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import javax.inject.Provider;
import javax.script.ScriptContext;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.internal.AbstractWikiUIExtension;

public class PanelWikiUIExtension
extends AbstractWikiUIExtension
implements BlockAsyncRendererDecorator {
    private static final String SP_PANELDOC = "paneldoc";
    private final ScriptContextManager scriptContextManager;
    private final Provider<XWikiContext> xcontextProvider;

    public PanelWikiUIExtension(BaseObject baseObject, String id, ComponentManager componentManager) throws ComponentLookupException, WikiComponentException {
        super(baseObject, UIExtension.class, id, componentManager);
        this.scope = WikiComponentScope.GLOBAL;
        this.scriptContextManager = (ScriptContextManager)componentManager.getInstance(ScriptContextManager.class);
        this.xcontextProvider = (Provider)componentManager.getInstance((Type)XWikiContext.TYPE_PROVIDER);
    }

    public String getId() {
        return this.getRoleHint();
    }

    public String getExtensionPointId() {
        return "platform.panels";
    }

    protected BlockAsyncRendererConfiguration configure() {
        BlockAsyncRendererConfiguration configuration = super.configure();
        configuration.setDefaultSyntax(this.syntax);
        return configuration;
    }

    private Object before() throws RenderingException {
        ScriptContext scriptContext = this.scriptContextManager.getCurrentScriptContext();
        Document paneldoc = (Document)scriptContext.getAttribute(SP_PANELDOC, 100);
        try {
            scriptContext.setAttribute(SP_PANELDOC, this.getPanelDocument(), 100);
        }
        catch (XWikiException e) {
            throw new RenderingException("Failed to get panel document", (Throwable)e);
        }
        return paneldoc;
    }

    private void after(Object obj) {
        this.scriptContextManager.getCurrentScriptContext().setAttribute(SP_PANELDOC, obj, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockAsyncRendererResult render(AsyncRenderer renderer, boolean async, boolean cached) throws RenderingException {
        Object obj = this.before();
        try {
            BlockAsyncRendererResult blockAsyncRendererResult = (BlockAsyncRendererResult)renderer.render(async, cached);
            return blockAsyncRendererResult;
        }
        finally {
            this.after(obj);
        }
    }

    private Document getPanelDocument() throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
        return document.newDocument(xcontext);
    }

    public Map<String, String> getParameters() {
        return Collections.emptyMap();
    }

    public WikiComponentScope getScope() {
        return WikiComponentScope.GLOBAL;
    }
}

