/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.panels.internal;

import com.xpn.xwiki.internal.template.SUExecutor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.uiextension.UIExtension;

public class PanelWikiUIExtension
implements UIExtension,
WikiComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PanelWikiUIExtension.class);
    private final EntityReferenceSerializer<String> serializer;
    private final DocumentReference documentReference;
    private final DocumentReference authorReference;
    private final XDOM xdom;
    private final Syntax syntax;
    private final RenderingContext renderingContext;
    private final Transformation macroTransformation;
    private final SUExecutor suExecutor;
    private final JobProgressManager progress;

    public PanelWikiUIExtension(DocumentReference documentReference, DocumentReference authorReference, XDOM xdom, Syntax syntax, ComponentManager componentManager) throws ComponentLookupException {
        this.documentReference = documentReference;
        this.authorReference = authorReference;
        this.xdom = xdom;
        this.syntax = syntax;
        this.macroTransformation = (Transformation)componentManager.getInstance(Transformation.class, "macro");
        this.serializer = (EntityReferenceSerializer)componentManager.getInstance((Type)EntityReferenceSerializer.TYPE_STRING);
        this.renderingContext = (RenderingContext)componentManager.getInstance(RenderingContext.class);
        this.suExecutor = (SUExecutor)componentManager.getInstance(SUExecutor.class);
        this.progress = (JobProgressManager)componentManager.getInstance(JobProgressManager.class);
    }

    public String getId() {
        return (String)this.serializer.serialize((EntityReference)this.documentReference, new Object[0]);
    }

    public String getExtensionPointId() {
        return "platform.panels";
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block execute() {
        final XDOM transformedXDOM = this.xdom.clone();
        this.progress.startStep((Object)this.getDocumentReference(), "panel.progress.execute", "Execute panel [{}]", new Object[]{this.getDocumentReference()});
        try {
            this.suExecutor.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TransformationContext transformationContext = new TransformationContext(transformedXDOM, PanelWikiUIExtension.this.syntax);
                    transformationContext.setId(PanelWikiUIExtension.this.getRoleHint());
                    ((MutableRenderingContext)PanelWikiUIExtension.this.renderingContext).transformInContext(PanelWikiUIExtension.this.macroTransformation, transformationContext, (Block)transformedXDOM);
                    return null;
                }
            }, this.getAuthorReference());
        }
        catch (Exception e) {
            LOGGER.error("Error while executing transformation for panel [{}]", (Object)this.documentReference.toString());
        }
        finally {
            this.progress.endStep((Object)this.getDocumentReference());
        }
        return new CompositeBlock(transformedXDOM.getChildren());
    }

    public Map<String, String> getParameters() {
        return Collections.emptyMap();
    }

    public Type getRoleType() {
        return UIExtension.class;
    }

    public String getRoleHint() {
        return this.getId();
    }

    public WikiComponentScope getScope() {
        return WikiComponentScope.GLOBAL;
    }
}

