/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.panels.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.panels.internal.PanelWikiUIExtension;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
@Named(value="panels")
public class PanelWikiUIExtensionComponentBuilder
implements WikiComponentBuilder {
    @Inject
    private QueryManager queryManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ContentParser parser;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentResolver;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public List<DocumentReference> getDocumentReferences() {
        ArrayList<DocumentReference> references = new ArrayList<DocumentReference>();
        try {
            Query query = this.queryManager.createQuery("select doc.fullName from Document doc, doc.object(Panels.PanelClass) as panel", "xwql");
            List results = query.execute();
            for (String fullName : results) {
                references.add(this.currentResolver.resolve((Object)fullName, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return references;
    }

    public List<WikiComponent> buildComponents(DocumentReference reference) throws WikiComponentException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        ArrayList<WikiComponent> components = new ArrayList<WikiComponent>();
        DocumentReference panelXClass = new DocumentReference(xcontext.getWikiId(), "Panels", "PanelClass");
        String content = (String)this.documentAccessBridge.getProperty(reference, panelXClass, "content");
        Syntax syntax = null;
        try {
            syntax = this.documentAccessBridge.getDocument(reference).getSyntax();
            DocumentReference authorReference = xcontext.getWiki().getDocument(reference, xcontext).getAuthorReference();
            XDOM xdom = this.parser.parse(content, syntax, (EntityReference)reference);
            components.add(new PanelWikiUIExtension(reference, authorReference, xdom, syntax, this.componentManager));
        }
        catch (WikiComponentException e) {
            throw e;
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException(String.format("Failed to initialize Panel UI extension [%s]", reference), (Throwable)e);
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Failed to retrieve panel document [%s]", reference), (Throwable)e);
        }
        return components;
    }
}

