/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.query.QueryParameter;
import org.xwiki.query.SecureQuery;
import org.xwiki.query.internal.ScriptQueryParameter;

public class ScriptQuery
implements SecureQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptQuery.class);
    private ComponentManager componentManager;
    private Query query;

    public ScriptQuery(Query query, ComponentManager cm) {
        this.query = query;
        this.componentManager = cm;
    }

    public Query addFilter(String filter) {
        if (!StringUtils.isBlank((CharSequence)filter)) {
            try {
                QueryFilter queryFilter = (QueryFilter)this.componentManager.getInstance(QueryFilter.class, filter);
                this.addFilter(queryFilter);
            }
            catch (ComponentLookupException e) {
                LOGGER.warn("Failed to load QueryFilter with component hint [{}]", (Object)filter);
            }
        }
        return this;
    }

    public long count() {
        long result = -1L;
        try {
            QueryManager queryManager = (QueryManager)this.componentManager.getInstance(QueryManager.class);
            Query countQuery = queryManager.createQuery(this.getStatement(), this.getLanguage());
            countQuery.setWiki(this.getWiki());
            for (Map.Entry<Integer, Object> entry : this.getPositionalParameters().entrySet()) {
                countQuery.bindValue(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : this.getNamedParameters().entrySet()) {
                countQuery.bindValue((String)entry.getKey(), entry.getValue());
            }
            for (QueryFilter queryFilter : this.getFilters()) {
                countQuery.addFilter(queryFilter);
            }
            countQuery.addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "count"));
            List results = countQuery.execute();
            result = (Long)results.get(0);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create count query for query [{}]", (Object)this.getStatement());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getStatement() {
        return this.query.getStatement();
    }

    @Override
    public String getLanguage() {
        return this.query.getLanguage();
    }

    @Override
    public boolean isNamed() {
        return this.query.isNamed();
    }

    @Override
    public Query setWiki(String wiki) {
        this.query.setWiki(wiki);
        return this;
    }

    @Override
    public String getWiki() {
        return this.query.getWiki();
    }

    @Override
    public Query bindValue(String var, Object val) {
        this.query.bindValue(var, val);
        return this;
    }

    @Override
    public Query bindValue(int index, Object val) {
        this.query.bindValue(index, val);
        return this;
    }

    @Override
    public Query bindValues(List<Object> values) {
        this.query.bindValues(values);
        return this;
    }

    @Override
    public QueryParameter bindValue(String var) {
        QueryParameter parameter = this.query.bindValue(var);
        return new ScriptQueryParameter(this, parameter);
    }

    @Override
    public Map<String, Object> getNamedParameters() {
        return this.query.getNamedParameters();
    }

    @Override
    public Map<Integer, Object> getPositionalParameters() {
        return this.query.getPositionalParameters();
    }

    @Override
    public Query addFilter(QueryFilter filter) {
        this.query.addFilter(filter);
        return this;
    }

    @Override
    public List<QueryFilter> getFilters() {
        return this.query.getFilters();
    }

    @Override
    public Query setLimit(int limit) {
        this.query.setLimit(limit);
        return this;
    }

    @Override
    public Query setOffset(int offset) {
        this.query.setOffset(offset);
        return this;
    }

    @Override
    public int getLimit() {
        return this.query.getLimit();
    }

    @Override
    public int getOffset() {
        return this.query.getOffset();
    }

    @Override
    public <T> List<T> execute() throws QueryException {
        return this.query.execute();
    }

    @Override
    public boolean isCurrentAuthorChecked() {
        return this.query instanceof SecureQuery ? ((SecureQuery)this.query).isCurrentAuthorChecked() : true;
    }

    @Override
    public SecureQuery checkCurrentAuthor(boolean checkCurrentAuthor) {
        return this;
    }

    @Override
    public boolean isCurrentUserChecked() {
        return this.query instanceof SecureQuery ? ((SecureQuery)this.query).isCurrentAuthorChecked() : false;
    }

    @Override
    public SecureQuery checkCurrentUser(boolean checkCurrentUser) {
        if (this.query instanceof SecureQuery) {
            ((SecureQuery)this.query).isCurrentAuthorChecked();
        }
        return this;
    }
}

