/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.query.QueryFilter;

public abstract class AbstractWhereQueryFilter
implements QueryFilter {
    private static final String WHERE = " where ";
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\s+where\\s+", 2);
    @Inject
    private Logger logger;

    protected boolean isFilterable(String statement) {
        return statement.indexOf("xwikidocument as doc") > -1 || statement.indexOf("xwikidocument doc") > -1;
    }

    protected String insertWhereClause(String whereClause, String statement, String language) {
        String result = statement.trim();
        String lowerStatement = result.toLowerCase();
        String original = result;
        if ("hql".equals(language) && this.isFilterable(lowerStatement)) {
            Matcher whereMatcher = WHERE_PATTERN.matcher(lowerStatement);
            int orderByIdx = Math.min(lowerStatement.indexOf(" order by "), Integer.MAX_VALUE);
            int groupByIdx = Math.min(lowerStatement.indexOf(" group by "), Integer.MAX_VALUE);
            orderByIdx = orderByIdx < 0 ? Integer.MAX_VALUE : orderByIdx;
            groupByIdx = groupByIdx < 0 ? Integer.MAX_VALUE : groupByIdx;
            int orderOrGroupByIdx = Math.min(orderByIdx, groupByIdx);
            if (whereMatcher.find()) {
                int whereEndIdx = Math.min(orderOrGroupByIdx, lowerStatement.length());
                result = result.substring(0, whereEndIdx) + ")" + result.substring(whereEndIdx);
                result = result.substring(0, whereMatcher.end()) + whereClause + " and (" + result.substring(whereMatcher.end());
            } else {
                result = orderOrGroupByIdx > 0 && orderOrGroupByIdx < Integer.MAX_VALUE ? result.substring(0, orderOrGroupByIdx) + WHERE + whereClause + result.substring(orderOrGroupByIdx) : result + WHERE + whereClause;
            }
        }
        if (!original.equals(result)) {
            this.logger.debug("Query [{}] has been transformed into [{}]", (Object)original, (Object)result);
        }
        return result;
    }
}

