/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.xwiki.query.Query;
import org.xwiki.query.WrappingQuery;
import org.xwiki.query.internal.DefaultQueryParameter;
import org.xwiki.query.internal.LikeParameterPart;
import org.xwiki.query.internal.LiteralParameterPart;
import org.xwiki.query.internal.ParameterPart;

public class EscapeLikeParametersQuery
extends WrappingQuery {
    private static final String ESCAPED_REPLACEMENT = "!$1";
    private List<String> modifiedNamedParameters;
    private List<Integer> modifiedPositionalParameters;

    public EscapeLikeParametersQuery(Query wrappedQuery) {
        super(wrappedQuery);
    }

    @Override
    public Map<String, Object> getNamedParameters() {
        return this.convertParameters(this.modifiedNamedParameters, super.getNamedParameters());
    }

    @Override
    public Map<Integer, Object> getPositionalParameters() {
        return this.convertParameters(this.modifiedPositionalParameters, super.getPositionalParameters());
    }

    private <T> Map<T, Object> convertParameters(List<T> modifiedParameters, Map<T, Object> parametersToEscape) {
        if (modifiedParameters != null) {
            LinkedHashMap<T, Object> escapedMap = new LinkedHashMap<T, Object>();
            for (Map.Entry<T, Object> entry : parametersToEscape.entrySet()) {
                if (modifiedParameters.contains(entry.getKey()) && entry.getValue() instanceof DefaultQueryParameter) {
                    DefaultQueryParameter queryParameter = (DefaultQueryParameter)entry.getValue();
                    StringBuffer buffer = new StringBuffer();
                    for (ParameterPart part : queryParameter.getParts()) {
                        if (part instanceof LiteralParameterPart) {
                            buffer.append(part.getValue().replaceAll("([%_!])", ESCAPED_REPLACEMENT));
                            continue;
                        }
                        if (part instanceof LikeParameterPart) {
                            buffer.append(part.getValue().replaceAll("([!])", ESCAPED_REPLACEMENT));
                            continue;
                        }
                        buffer.append(part.getValue());
                    }
                    escapedMap.put(entry.getKey(), buffer.toString());
                    continue;
                }
                escapedMap.put(entry.getKey(), entry.getValue());
            }
            return escapedMap;
        }
        return parametersToEscape;
    }

    @Override
    public String getStatement() {
        String statement;
        if (this.getLanguage().equals("hql")) {
            try {
                statement = this.modifyStatement(super.getStatement());
            }
            catch (JSQLParserException e) {
                throw new RuntimeException(String.format("Invalid HQL query [%s]", super.getStatement()), e);
            }
        } else {
            statement = super.getStatement();
        }
        return statement;
    }

    private String modifyStatement(String statementString) throws JSQLParserException {
        Select select;
        SelectBody selectBody;
        Statement statement = CCJSqlParserUtil.parse((String)statementString);
        if (statement instanceof Select && (selectBody = (select = (Select)statement).getSelectBody()) instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            Expression where = plainSelect.getWhere();
            where.accept((ExpressionVisitor)new XWikiExpressionVisitor());
        }
        return statement.toString();
    }

    private class XWikiLikeExpressionVisitor
    extends ExpressionVisitorAdapter {
        private XWikiLikeExpressionVisitor() {
        }

        public void visit(JdbcParameter parameter) {
            if (EscapeLikeParametersQuery.this.modifiedPositionalParameters == null) {
                EscapeLikeParametersQuery.this.modifiedPositionalParameters = new ArrayList();
            }
            Integer index = parameter.getIndex();
            if (parameter.isUseFixedIndex()) {
                EscapeLikeParametersQuery.this.modifiedPositionalParameters.add(index);
            } else {
                EscapeLikeParametersQuery.this.modifiedPositionalParameters.add(index - 1);
            }
        }

        public void visit(JdbcNamedParameter parameter) {
            if (EscapeLikeParametersQuery.this.modifiedNamedParameters == null) {
                EscapeLikeParametersQuery.this.modifiedNamedParameters = new ArrayList();
            }
            EscapeLikeParametersQuery.this.modifiedNamedParameters.add(parameter.getName());
        }
    }

    private class XWikiExpressionVisitor
    extends ExpressionVisitorAdapter {
        private XWikiExpressionVisitor() {
        }

        public void visit(LikeExpression expr) {
            if (expr.getEscape() == null) {
                expr.setEscape("!");
            }
            expr.accept((ExpressionVisitor)new XWikiLikeExpressionVisitor());
        }
    }
}

