/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import java.util.Set;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutorManager;

@Component(value="secure", roles={QueryExecutorManager.class})
public class SecureQueryExecutorManager
implements QueryExecutorManager {
    @Requirement
    private QueryExecutorManager nestedQueryExecutorManager;
    @Requirement
    private DocumentAccessBridge bridge;

    @Override
    public <T> List<T> execute(Query query) throws QueryException {
        if (query.getWiki() != null && !this.getBridge().hasProgrammingRights()) {
            throw new QueryException("Query#setWiki requires programming right", query, null);
        }
        if (query.isNamed() && !this.getBridge().hasProgrammingRights()) {
            throw new QueryException("Named queries requires programming right", query, null);
        }
        if (!"xwql".equals(query.getLanguage()) && !this.getBridge().hasProgrammingRights()) {
            throw new QueryException("Query languages others than XWQL require programming right", query, null);
        }
        if (query.getStatement().trim().toLowerCase().startsWith("select") && !this.getBridge().hasProgrammingRights()) {
            throw new QueryException("Full form XWQL statements requires programming right", query, null);
        }
        return this.getNestedQueryExecutorManager().execute(query);
    }

    @Override
    public Set<String> getLanguages() {
        return this.getNestedQueryExecutorManager().getLanguages();
    }

    protected DocumentAccessBridge getBridge() {
        return this.bridge;
    }

    protected QueryExecutorManager getNestedQueryExecutorManager() {
        return this.nestedQueryExecutorManager;
    }
}

