/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryExecutorManager;
import org.xwiki.query.QueryExecutorProvider;

@Component(roles={QueryExecutorManager.class})
@Singleton
public class DefaultQueryExecutorManager
implements QueryExecutorManager {
    @Inject
    private Map<String, QueryExecutor> executors;
    @Inject
    private QueryExecutorProvider namedQueryExecutorProvider;

    @Override
    public <T> List<T> execute(Query query) throws QueryException {
        if (query.isNamed()) {
            return ((QueryExecutor)this.namedQueryExecutorProvider.get()).execute(query);
        }
        return this.executors.get(query.getLanguage()).execute(query);
    }

    @Override
    public Set<String> getLanguages() {
        return Collections.unmodifiableSet(this.executors.keySet());
    }
}

