/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

public class ScriptQuery
implements Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptQuery.class);
    private ComponentManager componentManager;
    private Query query;

    public ScriptQuery(Query query, ComponentManager cm) {
        this.query = query;
        this.componentManager = cm;
    }

    public Query setFilter(String filter) {
        if (!StringUtils.isBlank((CharSequence)filter)) {
            try {
                this.setFilter((QueryFilter)this.componentManager.lookup(QueryFilter.class, filter));
            }
            catch (ComponentLookupException e) {
                LOGGER.warn("Failed to load QueryFilter with component hint [{}]", (Object)filter);
            }
        } else {
            this.query.setFilter(null);
        }
        return this;
    }

    @Override
    public String getStatement() {
        return this.query.getStatement();
    }

    @Override
    public String getLanguage() {
        return this.query.getLanguage();
    }

    @Override
    public boolean isNamed() {
        return this.query.isNamed();
    }

    @Override
    public Query setWiki(String wiki) {
        return this.query.setWiki(wiki);
    }

    @Override
    public String getWiki() {
        return this.query.getWiki();
    }

    @Override
    public Query bindValue(String var, Object val) {
        return this.query.bindValue(var, val);
    }

    @Override
    public Query bindValue(int index, Object val) {
        return this.query.bindValue(index, val);
    }

    @Override
    public Query bindValues(List<Object> values) {
        return this.query.bindValues(values);
    }

    @Override
    public Map<String, Object> getNamedParameters() {
        return this.query.getNamedParameters();
    }

    @Override
    public Map<Integer, Object> getPositionalParameters() {
        return this.query.getPositionalParameters();
    }

    @Override
    public Query setFilter(QueryFilter filter) {
        return this.query.setFilter(filter);
    }

    @Override
    public QueryFilter getFilter() {
        return this.query.getFilter();
    }

    @Override
    public Query setLimit(int limit) {
        return this.query.setLimit(limit);
    }

    @Override
    public Query setOffset(int offset) {
        return this.query.setOffset(offset);
    }

    @Override
    public int getLimit() {
        return this.query.getLimit();
    }

    @Override
    public int getOffset() {
        return this.query.getOffset();
    }

    @Override
    public <T> List<T> execute() throws QueryException {
        return this.query.execute();
    }
}

