/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.internal.AbstractQueryFilter;

@Component
@Named(value="count")
@Singleton
public class CountFilter
extends AbstractQueryFilter {
    @Inject
    private Logger logger;

    private boolean isFilterable(String statement) {
        List<String> selectColumns = this.getSelectColumns(statement);
        return selectColumns.contains("doc.fullName") || selectColumns.contains("distinct doc.fullName");
    }

    @Override
    public String filterStatement(String statement, String language) {
        String result;
        String original = result = statement.trim();
        if ("hql".equals(language) && this.isFilterable(statement)) {
            String distinct = this.getSelectColumns(statement).contains("distinct doc.fullName") ? "distinct " : "";
            result = "select count(" + distinct + "doc.fullName) " + result.substring(statement.indexOf("from XWikiDocument"));
            int oidx = result.indexOf("order by ");
            int gidx = result.indexOf("group by ");
            if (oidx > -1) {
                result = gidx > -1 && gidx > oidx ? result.substring(0, oidx) + result.substring(gidx) : result.substring(0, oidx);
            }
        }
        if (!original.equals(result)) {
            this.logger.debug("Query [{}] has been transformed into [{}]", (Object)original, (Object)result);
        }
        return result;
    }

    @Override
    public List filterResults(List results) {
        return results;
    }
}

