/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.internal.AbstractQueryFilter;

@Component
@Named(value="unique")
@Singleton
public class UniqueDocumentFilter
extends AbstractQueryFilter {
    @Inject
    private Logger logger;

    private boolean isFilterable(String statement) {
        return this.getSelectColumns(statement).contains("doc.fullName") && !this.getSelectColumns(statement).contains("distinct doc.fullName");
    }

    @Override
    public String filterStatement(String statement, String language) {
        StringBuilder builder = new StringBuilder();
        String result = statement;
        String original = statement;
        if ("hql".equals(language) && this.isFilterable(statement)) {
            String prettySeparator = ", ";
            builder.append("select distinct doc.fullName");
            List<String> selectColumns = this.getSelectColumns(statement);
            for (String column : selectColumns) {
                if ("doc.fullName".equals(column)) continue;
                builder.append(prettySeparator);
                builder.append(column);
            }
            for (String column : this.getOrderByColumns(statement)) {
                if ("doc.fullName".equals(column) || selectColumns.contains(column)) continue;
                builder.append(prettySeparator);
                builder.append(column);
            }
            builder.append(" ");
            builder.append(statement.substring(statement.indexOf(" from ")).trim());
            result = builder.toString();
        }
        if (!statement.equals(result)) {
            this.logger.debug("Query [{}] has been transformed into [{}]", (Object)original, (Object)result);
        }
        return result;
    }

    @Override
    public List filterResults(List results) {
        if (results.size() > 0 && results.get(0).getClass().isArray()) {
            ArrayList<Object> filteredResults = new ArrayList<Object>();
            for (Object result : results) {
                Object[] actualResult = (Object[])result;
                filteredResults.add(actualResult[0]);
            }
            return filteredResults;
        }
        return results;
    }
}

