/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="language")
@Singleton
public class LanguageQueryFilter
implements QueryFilter {
    private static final String SELECT_CLAUSE_TO_EXTEND = "select doc.fullName";

    private boolean isFilterable(String statement) {
        return statement.startsWith(SELECT_CLAUSE_TO_EXTEND);
    }

    @Override
    public String filterStatement(String statement, String language) {
        String result = statement.trim();
        if ("hql".equals(language) && this.isFilterable(result)) {
            result = "select doc.fullName, doc.language" + result.substring(SELECT_CLAUSE_TO_EXTEND.length());
        }
        return result;
    }

    @Override
    public List filterResults(List results) {
        return results;
    }
}

