/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.xwql.internal;

import org.apache.commons.lang.StringUtils;
import org.xwiki.query.jpql.analysis.DepthFirstAdapter;
import org.xwiki.query.jpql.node.AAbstractSchemaName;
import org.xwiki.query.jpql.node.APath;
import org.xwiki.query.jpql.node.ARangeVariableDeclaration;
import org.xwiki.query.jpql.node.ASelectStatement;
import org.xwiki.query.jpql.node.AXObjectDecl;
import org.xwiki.query.jpql.node.AXPath;
import org.xwiki.query.jpql.node.PPath;
import org.xwiki.query.jpql.node.PXObjectDecl;
import org.xwiki.query.jpql.node.Switch;
import org.xwiki.query.xwql.internal.InvalidQueryException;
import org.xwiki.query.xwql.internal.QueryContext;

public class QueryAnalyzer
extends DepthFirstAdapter {
    QueryContext context;
    String documentFromName = "Document";

    public QueryAnalyzer(QueryContext context) {
        this.context = context;
    }

    public void outASelectStatement(ASelectStatement node) {
        node.getSelectClause().apply((Switch)this);
        super.outASelectStatement(node);
    }

    public void caseAAbstractSchemaName(AAbstractSchemaName node) {
        String from = node.toString().trim();
        String alias = ((ARangeVariableDeclaration)node.parent()).getVariable().toString().trim();
        if (this.documentFromName.equals(from)) {
            this.context.addDocument(alias);
        }
    }

    public void caseAXObjectDecl(AXObjectDecl node) {
        String alias;
        String[] path = QueryAnalyzer.splitPath(node.getId().toString());
        if (path.length != 2) {
            throw new InvalidQueryException("docalias.object('classname') expected, but got:" + node.toString());
        }
        String docalias = path[0];
        String method = path[1];
        String className = QueryAnalyzer.unquote(node.getXClassName().toString().trim());
        String string = alias = node.parent().parent() instanceof ARangeVariableDeclaration ? ((ARangeVariableDeclaration)node.parent().parent()).getVariable().toString().trim() : null;
        if (!"object".equals(method)) {
            throw new InvalidQueryException("document's method + [" + method + "] is unsupported");
        }
        this.context.addObject(docalias, className, alias, (PXObjectDecl)node);
    }

    public void caseAPath(APath node) {
        String[] path = QueryAnalyzer.splitPath(node.toString());
        QueryContext.ObjectInfo obj = this.context.getObject(path[0]);
        if (path.length >= 2 && obj != null) {
            obj.addProperty(path[1], (PPath)node);
        }
    }

    public void outAXPath(AXPath node) {
        QueryContext.ObjectInfo obj = this.context.getObject(node.getXObjectDecl());
        String[] path = QueryAnalyzer.splitPath(node.getProperty().toString());
        obj.addProperty(path[0], (PPath)node);
        super.outAXPath(node);
    }

    public static String[] splitPath(String str) {
        return StringUtils.split((String)str.trim(), (String)".");
    }

    public static String unquote(String str) {
        if ((str = str.trim()).startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }
}

