/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.xwql.internal.hql;

import org.xwiki.query.jpql.analysis.DepthFirstAdapter;
import org.xwiki.query.jpql.node.ABrConditionalPrimary;
import org.xwiki.query.jpql.node.ACollectionMemberExpression;
import org.xwiki.query.jpql.node.AConditionalFactor;
import org.xwiki.query.jpql.node.AFromClause;
import org.xwiki.query.jpql.node.ARangeVariableDeclaration;
import org.xwiki.query.jpql.node.ASelectStatement;
import org.xwiki.query.jpql.node.ASingleConditionalExpression;
import org.xwiki.query.jpql.node.ASingleConditionalTerm;
import org.xwiki.query.jpql.node.AWhereClause;
import org.xwiki.query.jpql.node.Node;
import org.xwiki.query.jpql.node.PConditionalExpression;
import org.xwiki.query.jpql.node.PConditionalFactor;
import org.xwiki.query.jpql.node.PConditionalPrimary;
import org.xwiki.query.jpql.node.PConditionalTerm;
import org.xwiki.query.jpql.node.PWhereClause;
import org.xwiki.query.jpql.node.Switch;
import org.xwiki.query.jpql.node.TLbr;
import org.xwiki.query.jpql.node.TRbr;
import org.xwiki.query.jpql.node.Token;
import org.xwiki.query.xwql.internal.QueryContext;
import org.xwiki.query.xwql.internal.hql.Printer;

public class TreePrinter
extends DepthFirstAdapter {
    protected StringBuilder builder = new StringBuilder();
    private Printer printer;

    public TreePrinter(Printer printer) {
        this.printer = printer;
    }

    protected Printer getPrinter() {
        return this.printer;
    }

    protected QueryContext getContext() {
        return this.getPrinter().context;
    }

    public String toString() {
        return this.builder.toString();
    }

    public void defaultCase(Node node) {
        if (node instanceof Token) {
            Token token = (Token)node;
            this.builder.append(' ').append(token.getText());
        }
    }

    public void inASelectStatement(ASelectStatement node) {
        super.inASelectStatement(node);
        if (node.getWhereClause() == null) {
            node.setWhereClause((PWhereClause)new AWhereClause());
        } else if (this.printer.where.length() > 0) {
            AWhereClause where = (AWhereClause)node.getWhereClause();
            where.setConditionalExpression((PConditionalExpression)new ASingleConditionalExpression((PConditionalTerm)new ASingleConditionalTerm((PConditionalFactor)new AConditionalFactor(null, (PConditionalPrimary)new ABrConditionalPrimary(new TLbr(), where.getConditionalExpression(), new TRbr())))));
        }
    }

    public void caseARangeVariableDeclaration(ARangeVariableDeclaration node) {
        String from = node.getAbstractSchemaName().toString().trim();
        String alias = node.getVariable().toString().trim();
        if (this.getContext().getDocument(alias) != null) {
            from = "XWikiDocument";
        } else if (this.getContext().getObject(alias) != null) {
            from = "BaseObject";
        }
        this.builder.append(' ').append(from).append(" as ").append(alias);
    }

    public void outAFromClause(AFromClause node) {
        String from = this.getPrinter().from.toString();
        if (from.length() > 0) {
            this.builder.append(' ').append(from);
        }
    }

    public void outAWhereClause(AWhereClause node) {
        if (this.getPrinter().where.length() > 0) {
            if (node.getWhere() == null) {
                this.builder.append(" WHERE 1=1 ");
            }
            this.builder.append(this.getPrinter().where.toString());
        }
    }

    public void caseACollectionMemberExpression(ACollectionMemberExpression node) {
        this.builder.append(" in elements(");
        node.getPath().apply((Switch)this);
        this.builder.append(" )");
    }
}

