/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.JobException;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRendererExecutor;
import org.xwiki.rendering.async.internal.AsyncRendererJobRequest;
import org.xwiki.rendering.async.internal.AsyncRendererJobStatus;
import org.xwiki.rendering.async.internal.AsyncRendererWrapper;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.rendering.async.internal.block.DefaultBlockAsyncRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultBlockAsyncRendererExecutor
implements BlockAsyncRendererExecutor {
    @Inject
    private AsyncRendererExecutor executor;
    @Inject
    private Provider<DefaultBlockAsyncRenderer> rendererProvider;
    @Inject
    private JobProgressManager progress;

    @Override
    public Block execute(BlockAsyncRendererConfiguration configuration, Set<String> contextEntries) throws JobException, RenderingException {
        return this.execute(configuration, contextEntries, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block execute(BlockAsyncRendererConfiguration configuration, Set<String> contextEntries, Right right, EntityReference rightEntity) throws JobException, RenderingException {
        this.progress.pushLevelProgress(3, (Object)this);
        try {
            this.progress.startStep((Object)this, "async.block.progress.createRenderer", "Create asynchronous block renderer", new Object[0]);
            DefaultBlockAsyncRenderer renderer = (DefaultBlockAsyncRenderer)this.rendererProvider.get();
            this.progress.startStep((Object)this, "async.block.progress.initRenderer", "Initialize asynchronous block renderer", new Object[0]);
            renderer.initialize(configuration);
            this.progress.startStep((Object)this, "async.block.progress.executeRenderer", "Execute asynchronous block renderer", new Object[0]);
            Block block = this.execute(configuration.getDecorator() != null ? new DecoratorWrapper(configuration.getDecorator(), renderer) : renderer, contextEntries, right, rightEntity);
            return block;
        }
        finally {
            this.progress.popLevelProgress((Object)this);
        }
    }

    @Override
    public Block execute(BlockAsyncRenderer renderer, Set<String> contextEntries, Right right, EntityReference rightEntity) throws JobException, RenderingException {
        AsyncRendererJobStatus status = this.executor.render(renderer, contextEntries, right, rightEntity);
        BlockAsyncRendererResult result = (BlockAsyncRendererResult)status.getResult();
        if (result != null) {
            return result.getBlock();
        }
        Object placeholder = renderer.isInline() ? new FormatBlock() : new GroupBlock();
        placeholder.setParameter("class", "xwiki-async");
        placeholder.setParameter("data-xwiki-async-id", ((AsyncRendererJobRequest)status.getRequest()).getId().stream().map(this::encodeURL).collect(Collectors.joining("/")));
        return placeholder;
    }

    private String encodeURL(String element) {
        try {
            return URLEncoder.encode(element, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 encoding is not supported", e);
        }
    }

    private static class DecoratorWrapper
    extends AsyncRendererWrapper
    implements BlockAsyncRenderer {
        private BlockAsyncRendererDecorator decorator;

        DecoratorWrapper(BlockAsyncRendererDecorator decorator, BlockAsyncRenderer renderer) {
            super(renderer);
            this.decorator = decorator;
        }

        @Override
        public BlockAsyncRendererResult render(boolean async, boolean cached) throws RenderingException {
            return this.decorator.render((BlockAsyncRenderer)this.renderer, async, cached);
        }

        @Override
        public boolean isInline() {
            return ((BlockAsyncRenderer)this.renderer).isInline();
        }
    }
}

