/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.async.internal;

/**
 * The result of the {@link AsyncRenderer} execution.
 * 
 * @version $Id: 77bd91fcf94e2f3b7be75ac1bfb89d7d4210bc90 $
 * @since 10.10RC1
 */
public class AsyncRendererResult
{
    private String result;

    /**
     * @param result the resulting {@link String} (generally html)
     */
    public AsyncRendererResult(String result)
    {
        this.result = result;
    }

    /**
     * @return the result the resulting {@link String} (generally html)
     */
    public String getResult()
    {
        return this.result;
    }
}
