/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.JobException;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.AsyncRendererExecutor;
import org.xwiki.rendering.async.internal.AsyncRendererExecutorResponse;
import org.xwiki.rendering.async.internal.AsyncRendererWrapper;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.rendering.async.internal.block.DefaultBlockAsyncRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultBlockAsyncRendererExecutor
implements BlockAsyncRendererExecutor {
    @Inject
    private AsyncRendererExecutor executor;
    @Inject
    private Provider<DefaultBlockAsyncRenderer> rendererProvider;
    @Inject
    private JobProgressManager progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block execute(BlockAsyncRendererConfiguration configuration) throws JobException, RenderingException {
        this.progress.pushLevelProgress(3, (Object)this);
        try {
            this.progress.startStep((Object)this, "async.block.progress.createRenderer", "Create asynchronous block renderer", new Object[0]);
            DefaultBlockAsyncRenderer renderer = (DefaultBlockAsyncRenderer)this.rendererProvider.get();
            this.progress.startStep((Object)this, "async.block.progress.initRenderer", "Initialize asynchronous block renderer", new Object[0]);
            renderer.initialize(configuration);
            this.progress.startStep((Object)this, "async.block.progress.executeRenderer", "Execute asynchronous block renderer", new Object[0]);
            Block block = this.execute(configuration.getDecorator() != null ? new DecoratorWrapper(configuration.getDecorator(), renderer) : renderer, configuration);
            return block;
        }
        finally {
            this.progress.popLevelProgress((Object)this);
        }
    }

    @Override
    public Block execute(BlockAsyncRenderer renderer, AsyncRendererConfiguration configuration) throws JobException, RenderingException {
        AsyncRendererExecutorResponse response = this.executor.render(renderer, configuration);
        BlockAsyncRendererResult result = (BlockAsyncRendererResult)response.getStatus().getResult();
        if (result != null) {
            return result.getBlock();
        }
        Object placeholder = renderer.isInline() ? new FormatBlock() : new GroupBlock();
        placeholder.setParameter("class", "xwiki-async");
        placeholder.setParameter("data-xwiki-async-id", response.getJobIdHTTPPath());
        placeholder.setParameter("data-xwiki-async-client-id", response.getAsyncClientId());
        return placeholder;
    }

    @Override
    public String render(BlockAsyncRenderer renderer, AsyncRendererConfiguration configuration) throws JobException, RenderingException {
        AsyncRendererExecutorResponse response = this.executor.render(renderer, configuration);
        BlockAsyncRendererResult result = (BlockAsyncRendererResult)response.getStatus().getResult();
        if (result != null) {
            return result.getResult();
        }
        StringBuilder str = new StringBuilder();
        if (renderer.isInline()) {
            str.append("<span ");
        } else {
            str.append("<div ");
        }
        str.append("class=xwiki-async");
        str.append("data-xwiki-async-id=").append(response.getJobIdHTTPPath());
        str.append("data-xwiki-async-client-id=").append(response.getAsyncClientId());
        str.append("/>");
        return str.toString();
    }

    private static class DecoratorWrapper
    extends AsyncRendererWrapper
    implements BlockAsyncRenderer {
        private BlockAsyncRendererDecorator decorator;

        DecoratorWrapper(BlockAsyncRendererDecorator decorator, BlockAsyncRenderer renderer) {
            super(renderer);
            this.decorator = decorator;
        }

        @Override
        public BlockAsyncRendererResult render(boolean async, boolean cached) throws RenderingException {
            return this.decorator.render((BlockAsyncRenderer)this.renderer, async, cached);
        }

        @Override
        public boolean isInline() {
            return ((BlockAsyncRenderer)this.renderer).isInline();
        }

        @Override
        public Syntax getTargetSyntax() {
            return ((BlockAsyncRenderer)this.renderer).getTargetSyntax();
        }
    }
}

