/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.xwiki.rendering.async.internal.AsyncRendererJobRequest;
import org.xwiki.rendering.async.internal.AsyncRendererJobStatus;

public class AsyncRendererExecutorResponse {
    private final AsyncRendererJobStatus status;
    private final String asyncClientId;

    public AsyncRendererExecutorResponse(AsyncRendererJobStatus status) {
        this.status = status;
        this.asyncClientId = null;
    }

    public AsyncRendererExecutorResponse(AsyncRendererJobStatus status, String clientId) {
        this.status = status;
        this.asyncClientId = clientId;
        status.addClient(this.asyncClientId);
    }

    public AsyncRendererJobStatus getStatus() {
        return this.status;
    }

    public String getAsyncClientId() {
        return this.asyncClientId;
    }

    public String getJobIdHTTPPath() {
        List id = ((AsyncRendererJobRequest)this.getStatus().getRequest()).getId();
        if (id == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String element : id) {
            if (builder.length() > 0) {
                builder.append('/');
            }
            String encodedElement = this.encodeURL(element);
            encodedElement = this.encodeURL(encodedElement);
            builder.append(encodedElement);
        }
        return builder.toString();
    }

    private String encodeURL(String element) {
        try {
            return URLEncoder.encode(element, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 encoding is not supported", e);
        }
    }
}

