/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.cache;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.internal.macro.MacroContentParser;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.cache.CacheMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="cache")
@Singleton
public class CacheMacro
extends AbstractMacro<CacheMacroParameters>
implements Initializable {
    private static final String DESCRIPTION = "Caches content.";
    private static final String CONTENT_DESCRIPTION = "the content to cache.";
    @Inject
    private CacheManager cacheManager;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;
    private Cache<List<Block>> contentCache;

    public CacheMacro() {
        super("Cache", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), CacheMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public void initialize() throws InitializationException {
        super.initialize();
        CacheConfiguration configuration = new CacheConfiguration();
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(1000);
        lru.setTimeToLive(300);
        configuration.put((Object)"eviction", (Object)lru);
        try {
            this.contentCache = this.cacheManager.createNewLocalCache(configuration);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to create content cache", (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(CacheMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String cacheKey;
        if (parameters.getId() != null) {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.plainTextBlockRenderer.render((Collection)this.contentParser.parse(parameters.getId(), context, true, false), (WikiPrinter)printer);
            cacheKey = printer.toString();
        } else {
            cacheKey = content;
        }
        List result = (List)this.contentCache.get(cacheKey);
        if (result == null) {
            result = this.contentParser.parse(content, context, true, context.isInline());
            this.contentCache.set(cacheKey, (Object)result);
        }
        return result;
    }
}

