/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.internal.macro.cache.CacheKey;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.cache.CacheMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="cache")
@Singleton
public class CacheMacro
extends AbstractMacro<CacheMacroParameters> {
    private static final String DESCRIPTION = "Caches content.";
    private static final String CONTENT_DESCRIPTION = "the content to cache.";
    @Inject
    private CacheManager cacheManager;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;
    private Map<CacheKey, Cache<List<Block>>> contentCacheMap = new ConcurrentHashMap<CacheKey, Cache<List<Block>>>();

    public CacheMacro() {
        super("Cache", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), CacheMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(CacheMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String cacheKey;
        if (parameters.getId() != null) {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.plainTextBlockRenderer.render((Block)this.contentParser.parse(parameters.getId(), context, true, false), (WikiPrinter)printer);
            cacheKey = printer.toString();
        } else {
            cacheKey = content;
        }
        Cache<List<Block>> contentCache = this.getContentCache(parameters.getTimeToLive(), parameters.getMaxEntries());
        List result = (List)contentCache.get(cacheKey);
        if (result == null) {
            result = this.contentParser.parse(content, context, true, context.isInline()).getChildren();
            contentCache.set(cacheKey, (Object)result);
        }
        return result;
    }

    private Cache<List<Block>> getContentCache(int timeToLive, int maxEntries) throws MacroExecutionException {
        CacheKey cacheKey = new CacheKey(timeToLive, maxEntries);
        Cache contentCache = this.contentCacheMap.get(cacheKey);
        if (contentCache == null) {
            CacheConfiguration configuration = new CacheConfiguration();
            LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
            lru.setMaxEntries(maxEntries);
            lru.setTimeToLive(timeToLive);
            configuration.put((Object)"eviction", (Object)lru);
            try {
                contentCache = this.cacheManager.createNewLocalCache(configuration);
            }
            catch (CacheException e) {
                throw new MacroExecutionException("Failed to create content cache", (Throwable)e);
            }
            this.contentCacheMap.put(cacheKey, (Cache<List<Block>>)contentCache);
        }
        return contentCache;
    }
}

