/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.container;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.macro.container.LayoutManager;
import org.xwiki.skinx.SkinExtension;

@Component
@Named(value="columns")
@Singleton
public class ColumnsLayoutManager
implements LayoutManager {
    private static final String CLASS_ATTRIBUTE = "class";
    @Inject
    @Named(value="ssfx")
    private SkinExtension ssfx;

    @Override
    public void layoutContainer(Block container) {
        List innerGroups = container.getBlocks((BlockMatcher)new ClassBlockMatcher(GroupBlock.class), Block.Axes.CHILD);
        int count = innerGroups.size();
        if (innerGroups.size() == 0) {
            return;
        }
        HashMap<String, Comparable<Boolean>> skinxParams = new HashMap<String, Comparable<Boolean>>();
        skinxParams.put("forceSkinAction", Boolean.valueOf(true));
        skinxParams.put("columns", Integer.valueOf(count));
        this.ssfx.use("uicomponents/container/columns.css", skinxParams);
        for (int i = 0; i < count; ++i) {
            String oldClass;
            GroupBlock column = (GroupBlock)innerGroups.get(i);
            String classValue = "column";
            if (i == 0) {
                classValue = classValue + " first-column";
            }
            if (i == count - 1) {
                classValue = classValue + " last-column";
            }
            column.setParameter(CLASS_ATTRIBUTE, StringUtils.isEmpty((CharSequence)(oldClass = column.getParameter(CLASS_ATTRIBUTE))) ? classValue : oldClass + " " + classValue);
        }
        HashMap<String, String> clearFloatsParams = new HashMap<String, String>();
        clearFloatsParams.put(CLASS_ATTRIBUTE, "clearfloats");
        String oldClass = container.getParameter(CLASS_ATTRIBUTE);
        String newClass = "container-columns";
        container.setParameter(CLASS_ATTRIBUTE, StringUtils.isEmpty((CharSequence)oldClass) ? newClass : oldClass + " " + newClass);
        container.addChild((Block)new GroupBlock(clearFloatsParams));
    }

    @Override
    public Object getParameter(String parameterName) {
        return null;
    }

    @Override
    public void setParameter(String parameterName, Object parameterValue) {
    }
}

