/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.gallery;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.gallery.GalleryMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

@Component
@Named(value="gallery")
@Singleton
public class GalleryMacro
extends AbstractMacro<GalleryMacroParameters> {
    private static final String DESCRIPTION = "Displays the images found in the provided content using a slide-show view.";
    private static final String CONTENT_DESCRIPTION = "The images to be displayed in the gallery. All the images found in the provided wiki content are included. Images should be specified using the syntax of the current document. Example, for XWiki 2.0 syntax: image:Space.Page@alice.png image:http://www.example.com/path/to/bob.jpg";
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="jsfx")
    private SkinExtension jsfx;
    @Inject
    @Named(value="ssfx")
    private SkinExtension ssfx;

    public GalleryMacro() {
        super("Gallery", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), GalleryMacroParameters.class);
        this.setDefaultCategory("Layout");
    }

    public List<Block> execute(GalleryMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (context != null) {
            Map<String, Boolean> skinExtensionParameters = Collections.singletonMap("forceSkinAction", true);
            this.jsfx.use("uicomponents/widgets/gallery/gallery.js", skinExtensionParameters);
            this.ssfx.use("uicomponents/widgets/gallery/gallery.css");
            StringBuilder inlineStyle = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)parameters.getWidth())) {
                inlineStyle.append("width: ").append(parameters.getWidth()).append(';');
            } else if (parameters.getWidth() == null) {
                inlineStyle.append("width: 620px;");
            }
            if (!StringUtils.isEmpty((CharSequence)parameters.getHeight())) {
                inlineStyle.append("height: ").append(parameters.getHeight()).append(';');
            } else if (parameters.getHeight() == null) {
                inlineStyle.append("height: 349px;");
            }
            HashMap<String, String> groupParameters = new HashMap<String, String>();
            groupParameters.put("class", ("gallery " + StringUtils.defaultString((String)parameters.getClassNames())).trim());
            if (inlineStyle.length() > 0) {
                groupParameters.put("style", inlineStyle.toString());
            }
            GroupBlock galleryBlock = new GroupBlock(groupParameters);
            galleryBlock.addChildren(this.contentParser.parse(content, context, false, false).getChildren());
            return Collections.singletonList(galleryBlock);
        }
        return Collections.emptyList();
    }

    public boolean supportsInlineMode() {
        return false;
    }
}

