/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.include;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReferenceString;
import org.xwiki.model.reference.PageReference;
import org.xwiki.properties.annotation.PropertyAdvanced;
import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyDisplayHidden;
import org.xwiki.properties.annotation.PropertyDisplayType;
import org.xwiki.properties.annotation.PropertyFeature;
import org.xwiki.properties.annotation.PropertyGroup;
import org.xwiki.properties.annotation.PropertyName;
import org.xwiki.stability.Unstable;

public class IncludeMacroParameters {
    private String reference;
    private EntityType type = EntityType.DOCUMENT;
    private Context context = Context.CURRENT;
    private String section;
    private boolean excludeFirstHeading;

    @PropertyDescription(value="the reference of the resource to display")
    @PropertyDisplayType(value={EntityReferenceString.class})
    @PropertyFeature(value="reference")
    @PropertyGroup(value={"stringReference"})
    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getReference() {
        return this.reference;
    }

    @PropertyDescription(value="an optional id of a section to include in the specified document, e.g. 'HMyHeading'")
    @PropertyAdvanced
    public void setSection(String sectionId) {
        this.section = sectionId;
    }

    public String getSection() {
        return this.section;
    }

    @Unstable
    @PropertyName(value="Exclude First Heading")
    @PropertyDescription(value="Exclude the first heading from the included document or section.")
    @PropertyAdvanced
    public void setExcludeFirstHeading(boolean excludeFirstHeading) {
        this.excludeFirstHeading = excludeFirstHeading;
    }

    @Unstable
    public boolean isExcludeFirstHeading() {
        return this.excludeFirstHeading;
    }

    @PropertyDescription(value="defines whether the included page is executed in its separated execution context or whether it's executed in the context of the current page")
    @PropertyAdvanced
    @Deprecated
    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    @PropertyDescription(value="the type of the reference")
    @PropertyGroup(value={"stringReference"})
    @PropertyAdvanced
    @PropertyDisplayHidden
    public void setType(EntityType type) {
        this.type = type;
    }

    public EntityType getType() {
        return this.type;
    }

    @PropertyDescription(value="The reference of the page to include")
    @PropertyDisplayType(value={PageReference.class})
    @PropertyFeature(value="reference")
    @PropertyDisplayHidden
    public void setPage(String page) {
        this.reference = page;
        this.type = EntityType.PAGE;
    }

    public static enum Context {
        NEW,
        CURRENT;

    }
}

