/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.python;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.script.AbstractJSR223ScriptMacro;
import org.xwiki.rendering.macro.script.JSR223ScriptMacroParameters;

@Component
@Named(value="python")
@Singleton
public class PythonMacro
extends AbstractJSR223ScriptMacro<JSR223ScriptMacroParameters> {
    private static final String DESCRIPTION = "Executes a python script.";
    private static final String CONTENT_DESCRIPTION = "The python script to execute";

    public PythonMacro() {
        super("Python", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION));
    }

    protected Object eval(String content, ScriptEngine engine, ScriptContext scriptContext) throws ScriptException {
        String filename = (String)scriptContext.getAttribute("javax.script.filename");
        if (filename != null) {
            StringBuilder builder = null;
            int length = filename.length();
            for (int i = 0; i < length; ++i) {
                char c = filename.charAt(i);
                if (c >= '\u0100') {
                    if (builder == null) {
                        builder = new StringBuilder();
                        builder.append(filename.substring(0, i));
                    }
                    builder.append('_');
                    continue;
                }
                if (builder == null) continue;
                builder.append(c);
            }
            if (builder != null) {
                scriptContext.setAttribute("javax.script.filename", builder.toString(), 100);
            }
        }
        return super.eval(content, engine, scriptContext);
    }
}

