/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.rss;

import java.net.MalformedURLException;
import java.net.URL;
import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyMandatory;
import org.xwiki.rendering.macro.parameter.MacroParameterException;

public class RssMacroParameters {
    private String feed;
    private boolean content;
    private int count = 10;
    private boolean image;
    private String width = "";
    private boolean decoration = true;
    private URL feedURL;

    public String getFeed() {
        return this.feed;
    }

    @PropertyMandatory
    @PropertyDescription(value="URL of the RSS feed")
    public void setFeed(String feed) throws MacroParameterException {
        this.feed = feed;
        try {
            this.feedURL = new URL(feed);
        }
        catch (MalformedURLException ex) {
            throw new MacroParameterException("Malformed feed URL", (Throwable)ex);
        }
    }

    @PropertyDescription(value="If the feeds has an image associated, display it?")
    public void setImage(boolean image) {
        this.image = image;
    }

    public boolean isImage() {
        return this.image;
    }

    @PropertyDescription(value="The width, in px or %, of the box containing the RSS output (default is 30%)")
    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        return this.width;
    }

    @PropertyDescription(value="The maximum number of feed items to display on the page.")
    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public URL getFeedURL() {
        return this.feedURL;
    }

    @PropertyDescription(value="Display content for feed entries")
    public void setContent(boolean content) {
        this.content = content;
    }

    public boolean isContent() {
        return this.content;
    }

    @PropertyDescription(value="Display UI decorations around feed and feed entries")
    public void setDecoration(boolean decoration) {
        this.decoration = decoration;
    }

    public boolean isDecoration() {
        return this.decoration;
    }
}

