/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.internal.macro.script.AbstractScriptCheckerListener;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.script.MacroPermissionPolicy;
import org.xwiki.rendering.macro.script.PrivilegedScriptMacro;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="permissionchecker")
@Singleton
public class PermissionCheckerListener
extends AbstractScriptCheckerListener {
    @Inject
    private MacroManager macroManager;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private ComponentManager componentManager;

    public String getName() {
        return "permissionchecker";
    }

    @Override
    protected void check(CancelableEvent event, MacroTransformationContext context, ScriptMacroParameters parameters) {
        MacroId currentMacroId = new MacroId(context.getCurrentMacroBlock().getId());
        try {
            MacroPermissionPolicy mpp = (MacroPermissionPolicy)this.componentManager.getInstance(MacroPermissionPolicy.class, currentMacroId.getId());
            if (!mpp.hasPermission(parameters, context)) {
                String sourceContentReference = this.extractSourceContentReference((Block)context.getCurrentMacroBlock());
                String sourceText = "";
                sourceText = sourceContentReference != null ? String.format(" in [%s]", sourceContentReference) : "";
                event.cancel(String.format("The execution of the [%s] script macro is not allowed%s. Check the rights of its last author or the parameters if it's rendered from another script.", currentMacroId, sourceText));
            }
        }
        catch (ComponentLookupException e) {
            this.backwardCompatibilityCheck(currentMacroId, event);
        }
    }

    private void backwardCompatibilityCheck(MacroId macroId, CancelableEvent event) {
        try {
            if (!(this.macroManager.getMacro(macroId) instanceof PrivilegedScriptMacro)) {
                return;
            }
            if (!this.authorizationManager.hasAccess(Right.PROGRAM)) {
                event.cancel(String.format("You need Programming Rights to execute the script macro [%s]", macroId.getId()));
            }
        }
        catch (MacroLookupException macroLookupException) {
            // empty catch block
        }
    }

    private String extractSourceContentReference(Block source) {
        String contentSource = null;
        MetaDataBlock metaDataBlock = (MetaDataBlock)source.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null) {
            contentSource = (String)metaDataBlock.getMetaData().getMetaData("source");
        }
        return contentSource;
    }
}

