/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.script;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.classloader.ExtendedURLClassLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.context.Execution;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.internal.macro.script.AttachmentClassLoaderFactory;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.script.event.ScriptEvaluatedEvent;
import org.xwiki.script.event.ScriptEvaluatingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="scriptmacroclassloader")
public class ScriptClassLoaderHandlerListener
implements EventListener {
    private static final String EXECUTION_CONTEXT_ORIG_CLASSLOADER_KEY = "originalClassLoader";
    private static final String EXECUTION_CONTEXT_CLASSLOADER_KEY = "scriptClassLoader";
    private static final String EXECUTION_CONTEXT_JARPARAMS_KEY = "scriptJarParams";
    @Requirement
    private DocumentAccessBridge documentAccessBridge;
    @Requirement
    private Execution execution;
    @Requirement
    private AttachmentClassLoaderFactory attachmentClassLoaderFactory;

    public String getName() {
        return "scriptmacroclassloader";
    }

    public List<Event> getEvents() {
        LinkedList<Event> events = new LinkedList<Event>();
        events.add((Event)new ScriptEvaluatingEvent());
        events.add((Event)new ScriptEvaluatedEvent());
        return events;
    }

    public void onEvent(Event event, Object source, Object data) {
        if (!(data instanceof ScriptMacroParameters)) {
            return;
        }
        if (event instanceof ScriptEvaluatingEvent) {
            ScriptMacroParameters parameters = (ScriptMacroParameters)data;
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            this.execution.getContext().setProperty(EXECUTION_CONTEXT_ORIG_CLASSLOADER_KEY, (Object)originalClassLoader);
            try {
                ClassLoader newClassLoader = this.getClassLoader(parameters.getJars(), originalClassLoader);
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            catch (Exception exception) {
                ((CancelableEvent)event).cancel(exception.getMessage());
            }
        } else if (event instanceof ScriptEvaluatedEvent) {
            ClassLoader originalClassLoader = (ClassLoader)this.execution.getContext().getProperty(EXECUTION_CONTEXT_ORIG_CLASSLOADER_KEY);
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private ClassLoader getClassLoader(String jarsParameterValue, ClassLoader parent) throws MacroExecutionException {
        try {
            return this.findClassLoader(jarsParameterValue, parent);
        }
        catch (MacroExecutionException mee) {
            throw mee;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to add JAR URLs to the current class loader for [" + jarsParameterValue + "]", (Throwable)e);
        }
    }

    private ClassLoader findClassLoader(String jarsParameterValue, ClassLoader parent) throws Exception {
        ExtendedURLClassLoader cl = (ExtendedURLClassLoader)this.execution.getContext().getProperty(EXECUTION_CONTEXT_CLASSLOADER_KEY);
        if (cl == null) {
            cl = !StringUtils.isEmpty((String)jarsParameterValue) ? this.createOrExtendClassLoader(true, jarsParameterValue, parent) : this.attachmentClassLoaderFactory.createAttachmentClassLoader("", parent);
        } else {
            String cachedJarsParameterValue = (String)this.execution.getContext().getProperty(EXECUTION_CONTEXT_JARPARAMS_KEY);
            if (cachedJarsParameterValue != jarsParameterValue) {
                cl = this.createOrExtendClassLoader(false, jarsParameterValue, (ClassLoader)cl);
            }
        }
        this.execution.getContext().setProperty(EXECUTION_CONTEXT_CLASSLOADER_KEY, (Object)cl);
        return cl;
    }

    private ExtendedURLClassLoader createOrExtendClassLoader(boolean createNewClassLoader, String jarsParameterValue, ClassLoader classLoader) throws Exception {
        ExtendedURLClassLoader cl;
        if (this.canHaveJarsParameters()) {
            if (createNewClassLoader) {
                cl = this.attachmentClassLoaderFactory.createAttachmentClassLoader(jarsParameterValue, classLoader);
            } else {
                cl = (ExtendedURLClassLoader)classLoader;
                this.attachmentClassLoaderFactory.extendAttachmentClassLoader(jarsParameterValue, cl);
            }
        } else {
            throw new MacroExecutionException("You cannot pass additional jars since you don't have programming rights");
        }
        this.execution.getContext().setProperty(EXECUTION_CONTEXT_JARPARAMS_KEY, (Object)jarsParameterValue);
        return cl;
    }

    private boolean canHaveJarsParameters() {
        return this.documentAccessBridge.hasProgrammingRights();
    }
}

