/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.rendering.internal.macro.script.AbstractScriptCheckerListener;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.script.PrivilegedScriptMacro;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="permissionchecker")
@Singleton
public class PermissionCheckerListener
extends AbstractScriptCheckerListener {
    @Inject
    private MacroManager macroManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public String getName() {
        return "permissionchecker";
    }

    @Override
    protected void check(CancelableEvent event, MacroTransformationContext context, ScriptMacroParameters parameters) {
        try {
            MacroId currentMacro = new MacroId(context.getCurrentMacroBlock().getId());
            if (!(this.macroManager.getMacro(currentMacro) instanceof PrivilegedScriptMacro)) {
                return;
            }
            if (!this.documentAccessBridge.hasProgrammingRights()) {
                event.cancel("You don't have the right to execute this script");
            }
        }
        catch (MacroLookupException exception) {
            // empty catch block
        }
    }
}

