/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.script;

import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.script.AbstractScriptMacro;
import org.xwiki.rendering.macro.script.JSR223ScriptMacroParameters;
import org.xwiki.rendering.macro.script.PrivilegedScriptMacro;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.script.ScriptContextManager;

public abstract class AbstractJSR223ScriptMacro<P extends JSR223ScriptMacroParameters>
extends AbstractScriptMacro<P>
implements PrivilegedScriptMacro {
    private static final String EXECUTION_CONTEXT_ENGINE_KEY = "scriptEngines";
    protected ScriptEngineManager scriptEngineManager;
    @Inject
    private ScriptContextManager scriptContextManager;

    public AbstractJSR223ScriptMacro(String macroName) {
        super(macroName, null, JSR223ScriptMacroParameters.class);
    }

    public AbstractJSR223ScriptMacro(String macroName, String macroDescription) {
        super(macroName, macroDescription, JSR223ScriptMacroParameters.class);
    }

    public AbstractJSR223ScriptMacro(String macroName, String macroDescription, ContentDescriptor contentDescriptor) {
        super(macroName, macroDescription, contentDescriptor, JSR223ScriptMacroParameters.class);
    }

    public AbstractJSR223ScriptMacro(String macroName, String macroDescription, Class<? extends JSR223ScriptMacroParameters> parametersBeanClass) {
        super(macroName, macroDescription, parametersBeanClass);
    }

    public AbstractJSR223ScriptMacro(String macroName, String macroDescription, ContentDescriptor contentDescriptor, Class<? extends JSR223ScriptMacroParameters> parametersBeanClass) {
        super(macroName, macroDescription, contentDescriptor, parametersBeanClass);
    }

    public void initialize() throws InitializationException {
        super.initialize();
        this.scriptEngineManager = new ScriptEngineManager();
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected String getScriptEngineName(P parameters, MacroTransformationContext context) {
        return context.getCurrentMacroBlock().getId().toLowerCase();
    }

    protected ScriptContext getScriptContext() {
        return this.scriptContextManager.getScriptContext();
    }

    @Override
    protected List<Block> evaluateBlock(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result;
        if (StringUtils.isEmpty((CharSequence)content)) {
            return Collections.emptyList();
        }
        String engineName = this.getScriptEngineName(parameters, context);
        if (engineName != null) {
            try {
                ScriptEngine engine = this.getScriptEngine(engineName);
                if (engine == null) {
                    throw new MacroExecutionException("Can't find script engine with name [" + engineName + "]");
                }
                result = this.evaluateBlock(engine, parameters, content, context);
            }
            catch (ScriptException e) {
                throw new MacroExecutionException("Failed to evaluate Script Macro for content [" + content + "]", (Throwable)e);
            }
        } else {
            result = this.parseScriptResult(content, parameters, context);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Block> evaluateBlock(ScriptEngine engine, P parameters, String content, MacroTransformationContext context) throws ScriptException, MacroExecutionException {
        List<Object> result;
        ScriptContext scriptContext = this.getScriptContext();
        StringWriter stringWriter = new StringWriter();
        MetaDataBlock metaDataBlock = (MetaDataBlock)context.getCurrentMacroBlock().getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR_OR_SELF);
        if (metaDataBlock != null) {
            scriptContext.setAttribute("javax.script.filename", metaDataBlock.getMetaData().getMetaData("source"), 100);
        }
        scriptContext.setWriter(stringWriter);
        try {
            Object scriptResult = this.eval(content, engine, scriptContext);
            result = scriptResult instanceof XDOM ? ((XDOM)scriptResult).getChildren() : (scriptResult instanceof Block ? Collections.singletonList((Block)scriptResult) : (scriptResult instanceof List && !((List)scriptResult).isEmpty() && ((List)scriptResult).get(0) instanceof Block ? (List<Object>)scriptResult : this.parseScriptResult(stringWriter.toString(), parameters, context)));
        }
        finally {
            scriptContext.setWriter(null);
        }
        return result;
    }

    private ScriptEngine getScriptEngine(String engineName) {
        ScriptEngine engine;
        ExecutionContext executionContext = this.execution.getContext();
        HashMap<String, ScriptEngine> scriptEngines = (HashMap<String, ScriptEngine>)executionContext.getProperty(EXECUTION_CONTEXT_ENGINE_KEY);
        if (scriptEngines == null) {
            scriptEngines = new HashMap<String, ScriptEngine>();
            executionContext.setProperty(EXECUTION_CONTEXT_ENGINE_KEY, scriptEngines);
        }
        if ((engine = (ScriptEngine)scriptEngines.get(engineName)) == null) {
            engine = this.scriptEngineManager.getEngineByName(engineName);
            scriptEngines.put(engineName, engine);
        }
        return engine;
    }

    protected Object eval(String content, ScriptEngine engine, ScriptContext scriptContext) throws ScriptException {
        return engine.eval(content, scriptContext);
    }

    protected CompiledScript getCompiledScript(String content, Compilable engine) throws ScriptException {
        return engine.compile(content);
    }
}

