/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.useravatar;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.useravatar.UserAvatarMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="useravatar")
@Singleton
public class UserAvatarMacro
extends AbstractMacro<UserAvatarMacroParameters> {
    private static final String DESCRIPTION = "Allows displaying the avatar for a specific user.";
    private static final String USER_SPACE = "XWiki";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private SkinAccessBridge skinAccessBridge;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    @Named(value="current")
    private EntityReferenceValueProvider currentEntityReferenceValueProvider;
    @Inject
    private Logger logger;

    public UserAvatarMacro() {
        super("User Avatar", DESCRIPTION, UserAvatarMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(UserAvatarMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        DocumentReference userReference = this.currentDocumentReferenceResolver.resolve((Object)parameters.getUsername(), new Object[]{new EntityReference(USER_SPACE, EntityType.SPACE)});
        String fileName = null;
        if (this.documentAccessBridge.exists(userReference)) {
            Object avatarProperty = this.documentAccessBridge.getProperty(userReference, new DocumentReference(userReference.getWikiReference().getName(), USER_SPACE, "XWikiUsers"), "avatar");
            if (avatarProperty != null) {
                fileName = avatarProperty.toString();
            }
        } else {
            throw new MacroExecutionException("User [" + (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]) + "] is not registered in this wiki");
        }
        ResourceReference imageReference = new ResourceReference(this.skinAccessBridge.getSkinFile("icons/xwiki/noavatar.png"), ResourceType.URL);
        if (!StringUtils.isBlank((CharSequence)fileName)) {
            AttachmentReference attachmentReference = new AttachmentReference(fileName, userReference);
            try {
                if (this.documentAccessBridge.getAttachmentVersion(attachmentReference) != null) {
                    imageReference = new ResourceReference((String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0]), ResourceType.ATTACHMENT);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to get the avatar for user [{}]: [{}]. Using default.", this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        ImageBlock imageBlock = new ImageBlock(imageReference, false);
        imageBlock.setParameter("alt", "Picture of " + userReference.getName());
        imageBlock.setParameter("title", userReference.getName());
        if (parameters.getWidth() != null) {
            imageBlock.setParameter("width", String.valueOf(parameters.getWidth()));
        }
        if (parameters.getHeight() != null) {
            imageBlock.setParameter("height", String.valueOf(parameters.getHeight()));
        }
        List<ImageBlock> result = Collections.singletonList(imageBlock);
        return context.isInline() ? result : Collections.singletonList(new GroupBlock(result));
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

