/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.useravatar;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.useravatar.UserAvatarMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="useravatar")
@Singleton
public class UserAvatarMacro
extends AbstractMacro<UserAvatarMacroParameters> {
    private static final String DESCRIPTION = "Allows displaying the avatar for a specific user.";
    private static final String USER_SPACE = "XWiki";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private SkinAccessBridge skinAccessBridge;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    @Named(value="current")
    private EntityReferenceValueProvider currentEntityReferenceValueProvider;

    public UserAvatarMacro() {
        super("User Avatar", DESCRIPTION, UserAvatarMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(UserAvatarMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        ResourceReference imageReference;
        DocumentReference userReference = this.currentDocumentReferenceResolver.resolve((Object)parameters.getUsername(), new Object[]{new EntityReference(USER_SPACE, EntityType.SPACE)});
        String fileName = null;
        if (this.documentAccessBridge.exists(userReference)) {
            Object avatarProperty = this.documentAccessBridge.getProperty(userReference, new DocumentReference(this.currentEntityReferenceValueProvider.getDefaultValue(EntityType.WIKI), USER_SPACE, "XWikiUsers"), "avatar");
            if (avatarProperty != null) {
                fileName = avatarProperty.toString();
            }
        } else {
            throw new MacroExecutionException("User [" + (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]) + "] is not registered in this wiki");
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            imageReference = new ResourceReference(this.skinAccessBridge.getSkinFile("noavatar.png"), ResourceType.URL);
        } else {
            AttachmentReference attachmentReference = new AttachmentReference(fileName, userReference);
            imageReference = new ResourceReference((String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0]), ResourceType.ATTACHMENT);
        }
        ImageBlock imageBlock = new ImageBlock(imageReference, false);
        imageBlock.setParameter("alt", "Picture of " + userReference.getName());
        imageBlock.setParameter("title", userReference.getName());
        if (parameters.getWidth() != null) {
            imageBlock.setParameter("width", String.valueOf(parameters.getWidth()));
        }
        if (parameters.getHeight() != null) {
            imageBlock.setParameter("height", String.valueOf(parameters.getHeight()));
        }
        return Collections.singletonList(imageBlock);
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

