/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.velocity;

import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.script.AbstractScriptMacro;
import org.xwiki.rendering.macro.velocity.VelocityMacroConfiguration;
import org.xwiki.rendering.macro.velocity.VelocityMacroParameters;
import org.xwiki.rendering.macro.velocity.filter.VelocityMacroFilter;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Named(value="velocity")
@Singleton
public class VelocityMacro
extends AbstractScriptMacro<VelocityMacroParameters> {
    private static final String DESCRIPTION = "Executes a Velocity script.";
    private static final String CONTENT_DESCRIPTION = "the velocity script to execute";
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private VelocityMacroConfiguration configuration;
    @Inject
    private Logger logger;

    public VelocityMacro() {
        super("Velocity", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), VelocityMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected String evaluateString(VelocityMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String result = "";
        try {
            VelocityContext velocityContext = this.velocityManager.getVelocityContext();
            VelocityMacroFilter filter = this.getFilter(parameters);
            String cleanedContent = content;
            if (filter != null) {
                cleanedContent = filter.before(cleanedContent, velocityContext);
            }
            StringWriter writer = new StringWriter();
            String key = context.getTransformationContext().getId();
            if (key == null) {
                key = "unknown namespace";
            }
            this.velocityManager.getVelocityEngine().evaluate((Context)velocityContext, (Writer)writer, key, cleanedContent);
            result = writer.toString();
            if (filter != null) {
                result = filter.after(result, velocityContext);
            }
        }
        catch (XWikiVelocityException e) {
            throw new MacroExecutionException("Failed to evaluate Velocity Macro for content [" + content + "]", (Throwable)e);
        }
        return result;
    }

    private VelocityMacroFilter getFilter(VelocityMacroParameters parameters) {
        String filterName = parameters.getFilter();
        if (StringUtils.isEmpty((CharSequence)filterName) && StringUtils.isEmpty((CharSequence)(filterName = this.configuration.getFilter()))) {
            filterName = null;
        }
        VelocityMacroFilter filter = null;
        if (filterName != null) {
            try {
                filter = (VelocityMacroFilter)this.getComponentManager().getInstance(VelocityMacroFilter.class, filterName);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Can't find velocity maco cleaner", (Throwable)e);
            }
        }
        return filter;
    }
}

