/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.BlockReference;
import org.xwiki.model.reference.BlockReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;

@Component
@Named(value="currentsignedmacro")
@Singleton
public class CurrentSignedMacroBlockReferenceResolver
implements BlockReferenceResolver<Block> {
    @Inject
    @Named(value="signedmacro")
    private BlockReferenceResolver<Block> blockResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> sourceResolver;

    public BlockReference resolve(Block block, Object ... parameters) {
        return this.blockResolver.resolve((Object)block, new Object[]{this.getSourceReference(block)});
    }

    private EntityReference getSourceReference(Block block) {
        DocumentReference sourceRef = null;
        MetaDataBlock metaDataBlock = (MetaDataBlock)block.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null) {
            sourceRef = this.sourceResolver.resolve((Object)((String)metaDataBlock.getMetaData().getMetaData("source")), new Object[0]);
        }
        return sourceRef;
    }
}

