/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.wikibridge;

import java.util.Arrays;
import java.util.List;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.event.AbstractDocumentEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.macro.wikibridge.InsufficientPrivilegesException;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroException;
import org.xwiki.rendering.macro.wikibridge.WikiMacroFactory;
import org.xwiki.rendering.macro.wikibridge.WikiMacroManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="wikimacrolistener")
public class WikiMacroEventListener
extends AbstractLogEnabled
implements EventListener {
    @Requirement
    private WikiMacroFactory macroFactory;
    @Requirement
    private WikiMacroManager wikiMacroManager;

    public String getName() {
        return "wikimacrolistener";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof AbstractDocumentEvent) {
            DocumentModelBridge document = (DocumentModelBridge)source;
            DocumentReference documentReference = document.getDocumentReference();
            if (event instanceof DocumentCreatedEvent || event instanceof DocumentUpdatedEvent) {
                this.registerMacro(documentReference);
            } else if (event instanceof DocumentDeletedEvent) {
                this.unregisterMacro(documentReference);
            }
        }
    }

    private void registerMacro(DocumentReference documentReference) {
        if (this.unregisterMacro(documentReference) && this.macroFactory.containsWikiMacro(documentReference)) {
            WikiMacro wikiMacro;
            try {
                wikiMacro = this.macroFactory.createWikiMacro(documentReference);
            }
            catch (WikiMacroException e) {
                this.getLogger().debug(String.format("Failed to create wiki macro [%s]", documentReference), (Throwable)e);
                return;
            }
            this.registerMacro(documentReference, wikiMacro);
        }
    }

    private void registerMacro(DocumentReference documentReference, WikiMacro wikiMacro) {
        try {
            this.wikiMacroManager.registerWikiMacro(documentReference, wikiMacro);
        }
        catch (WikiMacroException e) {
            this.getLogger().debug(String.format("Unable to register macro [%s] in document [%s]", wikiMacro.getDescriptor().getId().getId(), documentReference), (Throwable)e);
        }
        catch (InsufficientPrivilegesException e) {
            this.getLogger().debug(String.format("Insufficient privileges for registering macro [%s] in document [%s]", wikiMacro.getDescriptor().getId().getId(), documentReference), (Throwable)e);
        }
    }

    private boolean unregisterMacro(DocumentReference documentReference) {
        boolean result = true;
        if (this.wikiMacroManager.hasWikiMacro(documentReference)) {
            try {
                this.wikiMacroManager.unregisterWikiMacro(documentReference);
            }
            catch (WikiMacroException e) {
                this.getLogger().debug(String.format("Unable to unregister macro in document [%s]", documentReference), (Throwable)e);
                result = false;
            }
        }
        return result;
    }
}

