/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.wikibridge;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.wikibridge.InsufficientPrivilegesException;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroException;
import org.xwiki.rendering.macro.wikibridge.WikiMacroManager;
import org.xwiki.rendering.macro.wikibridge.WikiMacroVisibility;

@Component
@Singleton
public class DefaultWikiMacroManager
implements WikiMacroManager {
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private ModelContext modelContext;
    private Map<DocumentReference, WikiMacroData> wikiMacroMap = new HashMap<DocumentReference, WikiMacroData>();

    @Override
    public boolean hasWikiMacro(DocumentReference documentReference) {
        return null != this.wikiMacroMap.get(documentReference);
    }

    @Override
    public void registerWikiMacro(DocumentReference documentReference, WikiMacro wikiMacro) throws InsufficientPrivilegesException, WikiMacroException {
        WikiMacroDescriptor macroDescriptor = (WikiMacroDescriptor)wikiMacro.getDescriptor();
        if (this.isAllowed(documentReference, macroDescriptor.getVisibility())) {
            DefaultComponentDescriptor componentDescriptor = new DefaultComponentDescriptor();
            componentDescriptor.setRole(Macro.class);
            componentDescriptor.setRoleHint(wikiMacro.getDescriptor().getId().getId());
            try {
                this.findComponentManager(macroDescriptor.getVisibility()).registerComponent((ComponentDescriptor)componentDescriptor, (Object)wikiMacro);
                this.wikiMacroMap.put(documentReference, new WikiMacroData(componentDescriptor.getRoleHint(), wikiMacro, this.bridge.getCurrentUser()));
            }
            catch (Exception e) {
                throw new WikiMacroException(String.format("Failed to register macro [%s] in [%s] for visibility [%s]", new Object[]{wikiMacro.getDescriptor().getId().getId(), documentReference, macroDescriptor.getVisibility()}), e);
            }
        } else {
            throw new InsufficientPrivilegesException(String.format("Unable to register macro [%s] in [%s] for visibility [%s] due to insufficient privileges", new Object[]{wikiMacro.getDescriptor().getId().getId(), documentReference, macroDescriptor.getVisibility()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unregisterWikiMacro(DocumentReference documentReference) throws WikiMacroException {
        WikiMacroData macroData = this.wikiMacroMap.get(documentReference);
        if (macroData == null) throw new WikiMacroException(String.format("Macro in [%s] isn't registered", documentReference));
        WikiMacroDescriptor macroDescriptor = (WikiMacroDescriptor)macroData.getWikiMacro().getDescriptor();
        if (!this.isAllowed(documentReference, macroDescriptor.getVisibility())) throw new WikiMacroException(String.format("Unable to unregister macro [%s] in [%s] for visibility [%s] due to insufficient privileges", new Object[]{macroData.getWikiMacro().getDescriptor().getId().getId(), documentReference, macroDescriptor.getVisibility()}));
        String currentUser = this.bridge.getCurrentUser();
        EntityReference currentEntityReference = this.modelContext.getCurrentEntityReference();
        try {
            this.bridge.setCurrentUser(macroData.getAuthor());
            this.modelContext.setCurrentEntityReference((EntityReference)documentReference);
            this.findComponentManager(macroDescriptor.getVisibility()).unregisterComponent(Macro.class, macroData.getHint());
            this.wikiMacroMap.remove(documentReference);
            return;
        }
        catch (Exception e) {
            throw new WikiMacroException(String.format("Failed to unregister macro [%s] in [%s] for visibility [%s]", new Object[]{macroData.getHint(), documentReference, macroDescriptor.getVisibility()}), e);
        }
        finally {
            this.bridge.setCurrentUser(currentUser);
            this.modelContext.setCurrentEntityReference(currentEntityReference);
        }
    }

    private boolean isAllowed(DocumentReference documentReference, WikiMacroVisibility visibility) {
        boolean isAllowed = false;
        switch (visibility) {
            case GLOBAL: {
                if (!this.bridge.hasProgrammingRights()) break;
                isAllowed = true;
                break;
            }
            default: {
                if (!this.bridge.isDocumentEditable(documentReference)) break;
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    private ComponentManager findComponentManager(WikiMacroVisibility visibility) throws ComponentLookupException {
        ComponentManager cm;
        switch (visibility) {
            case USER: {
                cm = (ComponentManager)this.rootComponentManager.lookup(ComponentManager.class, "user");
                break;
            }
            case WIKI: {
                cm = (ComponentManager)this.rootComponentManager.lookup(ComponentManager.class, "wiki");
                break;
            }
            default: {
                cm = this.rootComponentManager;
            }
        }
        return cm;
    }

    private static class WikiMacroData {
        private String hint;
        private WikiMacro wikiMacro;
        private String author;

        public WikiMacroData(String hint, WikiMacro wikiMacro, String author) {
            this.hint = hint;
            this.wikiMacro = wikiMacro;
            this.author = author;
        }

        public String getHint() {
            return this.hint;
        }

        public WikiMacro getWikiMacro() {
            return this.wikiMacro;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

