/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.wikibridge;

import java.util.HashMap;
import java.util.Map;

public enum WikiMacroVisibility {
    USER,
    WIKI,
    GLOBAL;

    private static final Map<String, WikiMacroVisibility> MAPPINGS;

    public static WikiMacroVisibility fromString(String visibilityAsString) {
        WikiMacroVisibility visibility = WIKI;
        if (MAPPINGS.containsKey(visibilityAsString)) {
            visibility = MAPPINGS.get(visibilityAsString);
        }
        return visibility;
    }

    static {
        MAPPINGS = new HashMap<String, WikiMacroVisibility>(){
            {
                this.put("Current User", USER);
                this.put("Current Wiki", WIKI);
                this.put("Global", GLOBAL);
            }
        };
    }
}

