/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.wikibridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.script.NestedScriptMacroEnabled;
import org.xwiki.rendering.internal.macro.wikibridge.WikiMacroBindingInitializer;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.parameter.MacroParameterException;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroExecutionFinishedEvent;
import org.xwiki.rendering.macro.wikibridge.WikiMacroExecutionStartsEvent;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameters;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;

public class DefaultWikiMacro
implements WikiMacro,
NestedScriptMacroEnabled {
    private static final String MACRO_KEY = "macro";
    private static final String MACRO_HINT = "macro";
    private static final String MACRO_CONTENT_KEY = "content";
    private static final String MACRO_PARAMS_KEY = "params";
    private static final String MACRO_CONTEXT_KEY = "context";
    private static final String MACRO_RESULT_KEY = "result";
    private static final WikiMacroExecutionStartsEvent STARTEXECUTION_EVENT = new WikiMacroExecutionStartsEvent();
    private static final WikiMacroExecutionFinishedEvent ENDEXECUTION_EVENT = new WikiMacroExecutionFinishedEvent();
    private MacroDescriptor descriptor;
    private DocumentReference macroDocumentReference;
    private DocumentReference macroAuthor;
    private boolean supportsInlineMode;
    private XDOM content;
    private Syntax syntax;
    private ComponentManager componentManager;

    public DefaultWikiMacro(DocumentReference macroDocumentReference, DocumentReference macroAuthor, boolean supportsInlineMode, MacroDescriptor descriptor, XDOM macroContent, Syntax syntax, ComponentManager componentManager) {
        this.macroDocumentReference = macroDocumentReference;
        this.macroAuthor = macroAuthor;
        this.supportsInlineMode = supportsInlineMode;
        this.descriptor = descriptor;
        this.content = macroContent;
        this.syntax = syntax;
        this.componentManager = componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Block> execute(WikiMacroParameters parameters, String macroContent, MacroTransformationContext context) throws MacroExecutionException {
        this.validate(parameters, macroContent);
        XDOM xdom = this.prepareWikiMacroContent(context);
        HashMap<String, Object> macroBinding = new HashMap<String, Object>();
        macroBinding.put(MACRO_PARAMS_KEY, parameters);
        macroBinding.put(MACRO_CONTENT_KEY, macroContent);
        macroBinding.put(MACRO_CONTEXT_KEY, context);
        macroBinding.put(MACRO_RESULT_KEY, null);
        try {
            List bindingInitializers = this.componentManager.getInstanceList(WikiMacroBindingInitializer.class);
            for (WikiMacroBindingInitializer bindingInitializer : bindingInitializers) {
                bindingInitializer.initialize(this.macroDocumentReference, parameters, macroContent, context, macroBinding);
            }
        }
        catch (ComponentLookupException bindingInitializers) {
            // empty catch block
        }
        ObservationManager observation = null;
        try {
            observation = (ObservationManager)this.componentManager.getInstance(ObservationManager.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        Map xwikiContext = null;
        try {
            Execution execution = (Execution)this.componentManager.getInstance(Execution.class);
            ExecutionContext econtext = execution.getContext();
            if (econtext != null) {
                xwikiContext = (Map)execution.getContext().getProperty("xwikicontext");
            }
        }
        catch (ComponentLookupException execution) {
            // empty catch block
        }
        try {
            Transformation macroTransformation = (Transformation)this.componentManager.getInstance(Transformation.class, "macro");
            if (xwikiContext != null) {
                xwikiContext.put("macro", macroBinding);
            }
            MacroBlock wikiMacroBlock = context.getCurrentMacroBlock();
            MacroMarkerBlock wikiMacroMarker = new MacroMarkerBlock(wikiMacroBlock.getId(), wikiMacroBlock.getParameters(), wikiMacroBlock.getContent(), xdom.getChildren(), wikiMacroBlock.isInline());
            MetaDataBlock metaDataBlock = new MetaDataBlock(Collections.singletonList(wikiMacroMarker), xdom.getMetaData());
            wikiMacroBlock.getParent().replaceChild((Block)metaDataBlock, (Block)wikiMacroBlock);
            wikiMacroBlock.setParent(metaDataBlock.getParent());
            wikiMacroBlock.setNextSiblingBlock(metaDataBlock.getNextSibling());
            wikiMacroBlock.setPreviousSiblingBlock(metaDataBlock.getPreviousSibling());
            try {
                if (observation != null) {
                    observation.notify((Event)STARTEXECUTION_EVENT, (Object)this, macroBinding);
                }
                TransformationContext txContext = new TransformationContext(context.getXDOM(), this.syntax);
                txContext.setId(context.getId());
                RenderingContext renderingContext = (RenderingContext)this.componentManager.getInstance(RenderingContext.class);
                ((MutableRenderingContext)renderingContext).transformInContext(macroTransformation, txContext, (Block)wikiMacroMarker);
            }
            finally {
                metaDataBlock.getParent().replaceChild((Block)wikiMacroBlock, (Block)metaDataBlock);
            }
            List<Block> list = this.extractResult(wikiMacroMarker.getChildren(), macroBinding, context);
            return list;
        }
        catch (Exception ex) {
            throw new MacroExecutionException("Error while performing internal macro transformations", (Throwable)ex);
        }
        finally {
            if (xwikiContext != null) {
                xwikiContext.remove("macro");
            }
            if (observation != null) {
                observation.notify((Event)ENDEXECUTION_EVENT, (Object)this);
            }
        }
    }

    private List<Block> extractResult(List<Block> blocks, Map<String, Object> macroContext, MacroTransformationContext context) {
        List result;
        Object resultObject = macroContext.get(MACRO_RESULT_KEY);
        if (resultObject != null && resultObject instanceof List) {
            result = (List)macroContext.get(MACRO_RESULT_KEY);
        } else {
            result = blocks;
            if (context.isInline()) {
                this.removeTopLevelParagraph(result);
            }
        }
        return result;
    }

    private void removeTopLevelParagraph(List<Block> blocks) {
        if (blocks.size() == 1 && blocks.get(0) instanceof ParagraphBlock) {
            Block paragraphBlock = blocks.remove(0);
            blocks.addAll(0, paragraphBlock.getChildren());
        }
    }

    private XDOM prepareWikiMacroContent(MacroTransformationContext context) {
        List children;
        XDOM xdom = this.content.clone();
        if (context.isInline() && (children = xdom.getChildren()).size() > 0 && children.get(0) instanceof MacroBlock) {
            MacroBlock old = (MacroBlock)children.get(0);
            MacroBlock replacement = new MacroBlock(old.getId(), old.getParameters(), old.getContent(), true);
            xdom.replaceChild((Block)replacement, (Block)old);
        }
        return xdom;
    }

    private void validate(WikiMacroParameters parameters, String macroContent) throws MacroExecutionException {
        Map parameterDescriptors = this.getDescriptor().getParameterDescriptorMap();
        for (String parameterName : parameterDescriptors.keySet()) {
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(parameterName);
            Object parameterValue = parameters.get(parameterName);
            if (parameterDescriptor.isMandatory() && null == parameterValue) {
                throw new MacroParameterException(String.format("Parameter [%s] is mandatory", parameterName));
            }
            Object parameterDefaultValue = parameterDescriptor.getDefaultValue();
            if (parameterValue != null || parameterDefaultValue == null) continue;
            parameters.set(parameterName, parameterDefaultValue);
        }
        if (this.getDescriptor().getContentDescriptor() != null && this.getDescriptor().getContentDescriptor().isMandatory() && (macroContent == null || macroContent.length() == 0)) {
            throw new MacroExecutionException("Missing macro content: this macro requires content (a body)");
        }
    }

    public MacroDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getPriority() {
        return 1000;
    }

    @Override
    public String getId() {
        return this.descriptor.getId().getId();
    }

    @Override
    public DocumentReference getDocumentReference() {
        return this.macroDocumentReference;
    }

    @Override
    public DocumentReference getAuthorReference() {
        return this.macroAuthor;
    }

    public int compareTo(Macro<?> macro) {
        return this.getPriority() - macro.getPriority();
    }

    public boolean supportsInlineMode() {
        return this.supportsInlineMode;
    }
}

