/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.macro.wikimacrocontent;

import com.xpn.xwiki.XWikiContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.AbstractNoParameterMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.stability.Unstable;

@Component
@Named(value="wikimacrocontent")
@Singleton
@Unstable
public class WikiMacroContentMacro
extends AbstractNoParameterMacro {
    private static final String DESCRIPTION = "Display editable content of a wikimacro.";
    private static final String WIKIMACRO_CONTENT = "content";
    private static final String WIKIMACRO_DESCRIPTOR = "descriptor";
    @Inject
    private Execution execution;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;

    public WikiMacroContentMacro() {
        super("WikiMacro Content", DESCRIPTION);
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private String extractMacroContent(Map<String, Object> macroInfo) {
        String content = null;
        if (macroInfo != null && macroInfo.containsKey(WIKIMACRO_CONTENT)) {
            content = (String)macroInfo.get(WIKIMACRO_CONTENT);
        }
        return content;
    }

    private MetaData getNonGeneratedContentMetaData(Map<String, Object> macroInfo) {
        ContentDescriptor contentDescriptor = this.getMacroContentDescriptor(macroInfo);
        return AbstractMacro.getNonGeneratedContentMetaData((ContentDescriptor)contentDescriptor);
    }

    private ContentDescriptor getMacroContentDescriptor(Map<String, Object> macroInfo) {
        ContentDescriptor result = null;
        if (macroInfo != null && macroInfo.containsKey(WIKIMACRO_DESCRIPTOR)) {
            MacroDescriptor macroDescriptor = (MacroDescriptor)macroInfo.get(WIKIMACRO_DESCRIPTOR);
            result = macroDescriptor.getContentDescriptor();
        }
        return result;
    }

    private XDOM parseContent(String macroContent, Map<String, Object> macroInfo, MacroTransformationContext context) throws MacroExecutionException {
        ContentDescriptor contentDescriptor = this.getMacroContentDescriptor(macroInfo);
        if (contentDescriptor == null || !contentDescriptor.getType().equals(Block.LIST_BLOCK_TYPE)) {
            try {
                return this.plainTextParser.parse((Reader)new StringReader(macroContent));
            }
            catch (ParseException e) {
                throw new MacroExecutionException("Error while parsing the macro content in plain.", (Throwable)e);
            }
        }
        return this.contentParser.parse(macroContent, context, true, context.isInline());
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result = Collections.emptyList();
        Map macroInfo = (Map)this.getContext().get((Object)"macro");
        String macroContent = this.extractMacroContent(macroInfo);
        if (macroContent != null) {
            MetaData nonGeneratedContentMetaData = this.getNonGeneratedContentMetaData(macroInfo);
            nonGeneratedContentMetaData.addMetaData("wikimacrocontent", (Object)"true");
            XDOM parse = this.parseContent(macroContent, macroInfo, context);
            result = Collections.singletonList(new MetaDataBlock(parse.getChildren(), nonGeneratedContentMetaData));
        }
        return result;
    }
}

