/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.macro.wikimacroparameter;

import com.xpn.xwiki.XWikiContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameters;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.wikimacro.macro.wikimacroparameter.WikiMacroParameterMacroParameters;
import org.xwiki.stability.Unstable;

@Component
@Named(value="wikimacroparameter")
@Singleton
@Unstable
public class WikiMacroParameterMacro
extends AbstractMacro<WikiMacroParameterMacroParameters> {
    private static final String DESCRIPTION = "Display editable parameter of a wikimacro.";
    private static final String WIKIMACRO_PARAMETERS = "params";
    private static final String WIKIMACRO_DESCRIPTOR = "descriptor";
    @Inject
    private Execution execution;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;

    public WikiMacroParameterMacro() {
        super("WikiMacro Parameter", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(false), WikiMacroParameterMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private String extractMacroParameter(Map<String, Object> macroInfo, String parameterName) {
        WikiMacroParameters parameters;
        String parameterContent = null;
        if (macroInfo != null && macroInfo.containsKey(WIKIMACRO_PARAMETERS) && (parameters = (WikiMacroParameters)macroInfo.get(WIKIMACRO_PARAMETERS)) != null) {
            parameterContent = (String)parameters.get(parameterName);
        }
        return parameterContent;
    }

    private MetaData getNonGeneratedParameterMetaData(Map<String, Object> macroInfo, String parameterName) {
        MetaData result;
        if (macroInfo != null && macroInfo.containsKey(WIKIMACRO_DESCRIPTOR)) {
            MacroDescriptor macroDescriptor = (MacroDescriptor)macroInfo.get(WIKIMACRO_DESCRIPTOR);
            result = AbstractMacro.getNonGeneratedContentMetaData((Map)macroDescriptor.getParameterDescriptorMap(), (String)parameterName);
        } else {
            result = AbstractMacro.getNonGeneratedContentMetaData(null);
        }
        return result;
    }

    private MacroDescriptor getMacroDescriptor(Map<String, Object> macroInfo) {
        MacroDescriptor result = null;
        if (macroInfo != null && macroInfo.containsKey(WIKIMACRO_DESCRIPTOR)) {
            result = (MacroDescriptor)macroInfo.get(WIKIMACRO_DESCRIPTOR);
        }
        return result;
    }

    private XDOM parseParameterValue(String macroParameterContent, String macroParameterName, Map<String, Object> macroInfo, MacroTransformationContext context) throws MacroExecutionException {
        MacroDescriptor macroDescriptor = this.getMacroDescriptor(macroInfo);
        ParameterDescriptor parameterDescriptor = null;
        if (macroDescriptor != null) {
            parameterDescriptor = (ParameterDescriptor)macroDescriptor.getParameterDescriptorMap().get(macroParameterName);
        }
        if (parameterDescriptor == null || !parameterDescriptor.getParameterType().equals(Block.LIST_BLOCK_TYPE)) {
            try {
                return this.plainTextParser.parse((Reader)new StringReader(macroParameterContent));
            }
            catch (ParseException e) {
                throw new MacroExecutionException("Error while parsing the macro parameter content in plain.", (Throwable)e);
            }
        }
        return this.contentParser.parse(macroParameterContent, context, true, context.isInline());
    }

    public List<Block> execute(WikiMacroParameterMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (parameters == null) {
            throw new MacroExecutionException("The parameter is mandatory.");
        }
        List<Block> result = Collections.emptyList();
        Map macroInfo = (Map)this.getContext().get((Object)"macro");
        String parameterValue = this.extractMacroParameter(macroInfo, parameters.getName());
        if (parameterValue != null) {
            MetaData nonGeneratedContentMetaData = this.getNonGeneratedParameterMetaData(macroInfo, parameters.getName());
            nonGeneratedContentMetaData.addMetaData("wikimacrocontent", (Object)"true");
            XDOM parse = this.parseParameterValue(parameterValue, parameters.getName(), macroInfo, context);
            result = Collections.singletonList(new MetaDataBlock(parse.getChildren(), nonGeneratedContentMetaData));
        }
        return result;
    }
}

