/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.configuration.ExtendedRenderingConfiguration;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroIdFactory;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="rendering")
@Singleton
public class RenderingScriptService
implements ScriptService {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;
    @Inject
    private RenderingConfiguration baseConfiguration;
    @Inject
    private ExtendedRenderingConfiguration extendedConfiguration;
    @Inject
    private MacroManager macroManager;
    @Inject
    private MacroIdFactory macroIdFactory;

    public List<Syntax> getAvailableParserSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (Parser parser : ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(Parser.class)) {
                syntaxes.add(parser.getSyntax());
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup parsers", (Throwable)e);
        }
        return syntaxes;
    }

    public List<Syntax> getAvailableRendererSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            List factories = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(PrintRendererFactory.class);
            for (PrintRendererFactory factory : factories) {
                syntaxes.add(factory.getSyntax());
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup renderers", (Throwable)e);
        }
        return syntaxes;
    }

    public List<String> getDefaultTransformationNames() {
        return this.baseConfiguration.getTransformationNames();
    }

    public XDOM parse(String text, String syntaxId) {
        XDOM result;
        try {
            Parser parser = (Parser)((ComponentManager)this.componentManagerProvider.get()).getInstance(Parser.class, syntaxId);
            result = parser.parse((Reader)new StringReader(text));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public String render(Block block, String outputSyntaxId) {
        String result;
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            BlockRenderer renderer = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, outputSyntaxId);
            renderer.render(block, (WikiPrinter)printer);
            result = printer.toString();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public Syntax resolveSyntax(String syntaxId) {
        Syntax syntax;
        try {
            syntax = Syntax.valueOf((String)syntaxId);
        }
        catch (ParseException exception) {
            syntax = null;
        }
        return syntax;
    }

    public String escape(String content, Syntax syntax) {
        char escapeChar;
        if (content == null || syntax == null) {
            return null;
        }
        String input = String.valueOf(content);
        try {
            escapeChar = this.getEscapeCharacter(syntax);
        }
        catch (Exception e) {
            return null;
        }
        char[] result = new char[input.length() * 2];
        for (int i = 0; i < input.length(); ++i) {
            result[2 * i] = escapeChar;
            result[2 * i + 1] = input.charAt(i);
        }
        return String.valueOf(result);
    }

    public List<Syntax> getConfiguredSyntaxes() {
        return this.extendedConfiguration.getConfiguredSyntaxes();
    }

    public List<Syntax> getDisabledSyntaxes() {
        return this.extendedConfiguration.getDisabledSyntaxes();
    }

    @Unstable
    public List<MacroDescriptor> getMacroDescriptors(Syntax syntax) throws MacroLookupException {
        ArrayList<MacroDescriptor> macroDescriptors = new ArrayList<MacroDescriptor>();
        for (MacroId id : this.macroManager.getMacroIds(syntax)) {
            macroDescriptors.add(this.macroManager.getMacro(id).getDescriptor());
        }
        return macroDescriptors;
    }

    @Unstable
    public MacroId resolveMacroId(String macroIdAsString) {
        try {
            return this.macroIdFactory.createMacroId(macroIdAsString);
        }
        catch (ParseException e) {
            this.logger.warn("Failed to resolve macro id [{}]. Root cause is: [{}]", (Object)macroIdAsString, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    @Unstable
    public MacroDescriptor getMacroDescriptor(MacroId macroId) {
        if (this.macroManager.exists(macroId)) {
            try {
                return this.macroManager.getMacro(macroId).getDescriptor();
            }
            catch (MacroLookupException macroLookupException) {
                // empty catch block
            }
        }
        return null;
    }

    private char getEscapeCharacter(Syntax syntax) throws IllegalArgumentException {
        if (Syntax.XWIKI_1_0.equals((Object)syntax)) {
            return '\\';
        }
        if (Syntax.XWIKI_2_0.equals((Object)syntax) || Syntax.XWIKI_2_1.equals((Object)syntax)) {
            return '~';
        }
        throw new IllegalArgumentException(String.format("Escaping is not supported for Syntax [%s]", syntax));
    }
}

