/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;

@Component
@Singleton
public class XWikiLinkLabelGenerator
implements LinkLabelGenerator {
    @Inject
    private RenderingConfiguration renderingConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceResolver<ResourceReference> resourceReferenceResolver;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localReferenceSerializer;

    public String generate(ResourceReference reference) {
        StringBuilder result = new StringBuilder();
        String format = this.renderingConfiguration.getLinkLabelFormat();
        EntityReference resolvedReference = this.resourceReferenceResolver.resolve((Object)reference, EntityType.DOCUMENT, new Object[0]);
        if (resolvedReference == null) {
            throw new IllegalArgumentException(String.valueOf(reference));
        }
        DocumentReference documentReference = new DocumentReference(resolvedReference);
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '%' && i + 1 < format.length()) {
                char cc = format.charAt(++i);
                switch (cc) {
                    case 's': {
                        result.append(this.getSpacesLabel(documentReference));
                        break;
                    }
                    case 'p': {
                        result.append(this.getPageLabel(documentReference));
                        break;
                    }
                    case 't': {
                        result.append(this.getTitleLabel(documentReference));
                        break;
                    }
                    case 'P': {
                        result.append(this.getCamelPageLabel(documentReference));
                        break;
                    }
                    case 'w': {
                        result.append(this.getWikiLabel(documentReference));
                        break;
                    }
                    case 'l': {
                        char ccc;
                        if (i + 1 < format.length()) {
                            if ((ccc = format.charAt(++i)) == 's') {
                                result.append(this.getLastSpaceLabel(documentReference));
                                break;
                            }
                            result.append(c);
                            result.append(cc);
                            result.append(ccc);
                            break;
                        }
                        result.append(c);
                        result.append(cc);
                        break;
                    }
                    case 'n': {
                        char ccc;
                        if (i + 1 < format.length()) {
                            if ((ccc = format.charAt(++i)) == 'p') {
                                result.append(this.getNestedPageLabel(documentReference));
                                break;
                            }
                            result.append(c);
                            result.append(cc);
                            result.append(ccc);
                            break;
                        }
                        result.append(c);
                        result.append(cc);
                        break;
                    }
                    case 'N': {
                        char ccc;
                        if (i + 1 < format.length()) {
                            if ((ccc = format.charAt(++i)) == 'P') {
                                result.append(this.getCamelNestedPageLabel(documentReference));
                                break;
                            }
                            result.append(c);
                            result.append(cc);
                            result.append(ccc);
                            break;
                        }
                        result.append(c);
                        result.append(cc);
                        break;
                    }
                    default: {
                        result.append(c);
                        result.append(cc);
                    }
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String getCamelNestedPageLabel(DocumentReference documentReference) {
        return this.convertCamelString(this.getNestedPageLabel(documentReference));
    }

    private String getLastSpaceLabel(DocumentReference documentReference) {
        return documentReference.getLastSpaceReference().getName();
    }

    private String getWikiLabel(DocumentReference documentReference) {
        return documentReference.getWikiReference().getName();
    }

    private String getCamelPageLabel(DocumentReference documentReference) {
        return this.convertCamelString(documentReference.getName());
    }

    private String convertCamelString(String value) {
        return value.replaceAll("([a-z])([A-Z])", "$1 $2");
    }

    private String getPageLabel(DocumentReference documentReference) {
        return documentReference.getName();
    }

    private String getSpacesLabel(DocumentReference documentReference) {
        return (String)this.localReferenceSerializer.serialize(documentReference.getParent(), new Object[0]);
    }

    private String getNestedPageLabel(DocumentReference documentReference) {
        String result = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName().equals(documentReference.getName()) ? documentReference.getLastSpaceReference().getName() : documentReference.getName();
        return result;
    }

    private String getTitleLabel(DocumentReference documentReference) {
        String result;
        try {
            DocumentModelBridge document = this.documentAccessBridge.getTranslatedDocumentInstance(documentReference);
            result = StringUtils.isNotBlank((CharSequence)document.getTitle()) ? document.getTitle() : this.getNestedPageLabel(documentReference);
        }
        catch (Exception e) {
            result = this.getNestedPageLabel(documentReference);
        }
        return result;
    }
}

