/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.internal.configuration.XWikiRenderingConfiguration;
import org.xwiki.rendering.transformation.Transformation;

@Component
public class DefaultXWikiRenderingConfiguration
implements XWikiRenderingConfiguration {
    private static final String PREFIX = "rendering.";
    private static final String DEFAULT_LINK_LABEL_FORMAT = "%p";
    @Requirement
    private ConfigurationSource configuration;
    @Requirement
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public String getLinkLabelFormat() {
        return (String)this.configuration.getProperty("rendering.linkLabelFormat", (Object)DEFAULT_LINK_LABEL_FORMAT);
    }

    @Override
    public int getImageWidthLimit() {
        return (Integer)this.configuration.getProperty("rendering.imageWidthLimit", (Object)-1);
    }

    @Override
    public int getImageHeightLimit() {
        return (Integer)this.configuration.getProperty("rendering.imageHeightLimit", (Object)-1);
    }

    @Override
    public boolean isImageDimensionsIncludedInImageURL() {
        return (Boolean)this.configuration.getProperty("rendering.imageDimensionsIncludedInImageURL", (Object)true);
    }

    public Properties getInterWikiDefinitions() {
        return (Properties)this.configuration.getProperty("rendering.interWikiDefinitions", Properties.class);
    }

    public List<Transformation> getTransformations() {
        ArrayList<Transformation> transformations = new ArrayList<Transformation>();
        for (String hint : (List)this.configuration.getProperty("rendering.transformations", Arrays.asList("macro", "icon"))) {
            try {
                transformations.add((Transformation)this.componentManager.lookup(Transformation.class, hint));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to locate transformation with hint [" + hint + "], ignoring it.");
            }
        }
        Collections.sort(transformations);
        return transformations;
    }
}

