/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.scripting;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="rendering")
@Singleton
public class RenderingScriptService
implements ScriptService {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RenderingConfiguration configuration;

    public List<Syntax> getAvailableParserSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (Parser parser : this.componentManager.lookupList(Parser.class)) {
                syntaxes.add(parser.getSyntax());
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return syntaxes;
    }

    public List<Syntax> getAvailableRendererSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (PrintRendererFactory factory : this.componentManager.lookupList(PrintRendererFactory.class)) {
                syntaxes.add(factory.getSyntax());
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return syntaxes;
    }

    public List<String> getDefaultTransformationNames() {
        return this.configuration.getTransformationNames();
    }

    public XDOM parse(String text, String syntaxId) {
        XDOM result;
        try {
            result = ((Parser)this.componentManager.lookup(Parser.class, syntaxId)).parse((Reader)new StringReader(text));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public String render(Block block, String outputSyntaxId) {
        String result;
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            ((BlockRenderer)this.componentManager.lookup(BlockRenderer.class, outputSyntaxId)).render(block, (WikiPrinter)printer);
            result = printer.toString();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }
}

